/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.formatter;

import de.fraunhofer.iosb.ilt.frostserver.formatter.FormatWriter;
import de.fraunhofer.iosb.ilt.frostserver.formatter.FormatWriterGeneric;
import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.io.IOException;
import java.util.Map;
import org.geojson.GeoJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFormatterDefault
implements ResultFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultFormatterDefault.class);

    public ResultFormatterDefault() {
        LOGGER.trace("Creating a new resultFormatter.");
    }

    @Override
    public FormatWriter format(ResourcePath path, Query query, Object result, boolean useAbsoluteNavigationLinks) {
        try {
            String entityJsonString;
            if (Entity.class.isAssignableFrom(result.getClass())) {
                Entity entity = (Entity)result;
                LOGGER.trace("Formatting as Entity.");
                return target -> JsonWriter.writeEntity(target, entity);
            }
            if (EntitySet.class.isAssignableFrom(result.getClass())) {
                EntitySet entitySet = (EntitySet)result;
                LOGGER.trace("Formatting as EntitySet.");
                return target -> JsonWriter.writeEntityCollection(target, entitySet, query);
            }
            if (path != null && path.isValue()) {
                LOGGER.trace("Formatting as $Value.");
                entityJsonString = result instanceof Map || result instanceof GeoJsonObject ? JsonWriter.writeObject(result) : (result instanceof Id ? ((Id)result).getValue().toString() : result.toString());
            } else {
                LOGGER.trace("Formatting as Object.");
                entityJsonString = JsonWriter.writeObject(result);
            }
            return new FormatWriterGeneric(entityJsonString);
        }
        catch (IOException ex2) {
            LOGGER.error("Failed to format response.", ex2);
            return null;
        }
    }

    @Override
    public String getContentType() {
        return "application/json";
    }
}

