/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FilteringComboBox<E>
extends JComboBox<E> {
    private final E[] allElements;

    public FilteringComboBox(E[] elements) {
        super(elements);
        this.allElements = elements;
        this.setEditable(true);
        final JTextField textfield = (JTextField)this.getEditor().getEditorComponent();
        textfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke2) {
                if (ke2.isControlDown()) {
                    return;
                }
                switch (ke2.getKeyCode()) {
                    case 10: 
                    case 16: 
                    case 17: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: {
                        return;
                    }
                }
                SwingUtilities.invokeLater(() -> FilteringComboBox.this.filterElements(textfield.getText().toLowerCase()));
            }
        });
    }

    private void filterElements(String enteredText) {
        String lowCaseTest = enteredText.toLowerCase();
        ArrayList<E> entriesFiltered = new ArrayList<E>();
        for (E entry : this.allElements) {
            if (!entry.toString().toLowerCase().contains(lowCaseTest)) continue;
            entriesFiltered.add(entry);
        }
        if (entriesFiltered.size() > 0) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
            model.removeAllElements();
            model.addAll(entriesFiltered);
            this.setSelectedItem(enteredText);
            JTextField textfield = (JTextField)this.getEditor().getEditorComponent();
            textfield.setCaretPosition(textfield.getText().length());
            this.showPopup();
        } else {
            this.hidePopup();
        }
    }
}

