/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorBigDecimal;
import java.math.BigDecimal;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FactoryBigDecimalSwing
implements GuiFactorySwing {
    private static final Logger LOGGER = LoggerFactory.getLogger(FactoryBigDecimalSwing.class.getName());
    private final EditorBigDecimal parentEditor;
    private JTextField swComponent;

    public FactoryBigDecimalSwing(EditorBigDecimal parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public JComponent getComponent() {
        if (this.swComponent == null) {
            this.createComponent();
        }
        return this.swComponent;
    }

    private void createComponent() {
        BigDecimal rawValue = this.parentEditor.getRawValue();
        if (rawValue == null) {
            rawValue = BigDecimal.ZERO;
        }
        BigDecimal min2 = this.parentEditor.getMin();
        BigDecimal max = this.parentEditor.getMax();
        if (min2 != null && min2.compareTo(rawValue) > 0) {
            this.parentEditor.setRawValue(min2);
        }
        if (max != null && max.compareTo(rawValue) < 0) {
            this.parentEditor.setRawValue(min2);
        }
        this.swComponent = new JTextField();
        this.swComponent.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                try {
                    BigDecimal unused = new BigDecimal(((JTextField)input).getText());
                    return true;
                }
                catch (NumberFormatException exc) {
                    LOGGER.trace("Not a decimal.", exc);
                    return false;
                }
            }
        });
        this.swComponent.addActionListener(e2 -> this.readComponent());
        this.fillComponent();
    }

    public void fillComponent() {
        BigDecimal rawValue = this.parentEditor.getRawValue();
        if (rawValue == null) {
            rawValue = BigDecimal.ZERO;
        }
        this.swComponent.setText("" + rawValue);
    }

    public void readComponent() {
        if (this.swComponent != null) {
            try {
                this.parentEditor.setRawValue(new BigDecimal(this.swComponent.getText()));
            }
            catch (NumberFormatException exc) {
                LOGGER.error("Failed to parse text to number: " + this.swComponent.getText());
            }
            this.fillComponent();
        }
    }
}

