/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemString;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryStringFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryStringSwing;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Set;

public class EditorString
extends EditorDefault<String> {
    private String dflt;
    private String value;
    private int lines = 1;
    private Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactoryStringSwing factorySwing;
    private FactoryStringFx factoryFx;

    public EditorString() {
    }

    public EditorString(String deflt, int lines) {
        this(deflt, lines, "", "");
    }

    public EditorString(String deflt, int lines, String label, String description) {
        this.dflt = deflt;
        this.value = deflt;
        this.lines = lines;
        this.setLabel(label);
        this.setDescription(description);
    }

    @Override
    public void initFor(Field field) {
        EdOptsString annotation = field.getAnnotation(EdOptsString.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdOptsString annotation to use this editor: " + field.getName());
        }
        this.lines = annotation.lines();
        if (!annotation.dfltIsNull()) {
            this.dflt = annotation.dflt();
        }
        this.value = this.dflt;
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(annotation.profilesEdit());
    }

    @Override
    public void setConfig(JsonElement config) {
        this.value = config != null && config.isJsonPrimitive() ? config.getAsJsonPrimitive().getAsString() : this.dflt;
        this.fillComponent();
    }

    @Override
    public JsonElement getConfig() {
        this.readComponent();
        if (this.value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(this.value);
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemString item = (ItemString)((ItemString)((ItemString)new ItemString().setDeflt(this.dflt)).setTitle(this.getLabel())).setDescription(this.getDescription());
        if (rootSchema == null) {
            return new RootSchema(item);
        }
        return item;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryStringSwing(this);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryStringFx(this);
        }
        return this.factoryFx;
    }

    protected final void setDflt(String dflt) {
        this.dflt = dflt;
    }

    private void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    private void readComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.readComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.readComponent();
        }
    }

    public int getLines() {
        return this.lines;
    }

    public String getRawValue() {
        return this.value;
    }

    public void setRawValue(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        this.readComponent();
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.fillComponent();
    }

    public String getDflt() {
        return this.dflt;
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
        this.fillComponent();
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile);
    }

    @Override
    public boolean isDefault() {
        this.readComponent();
        return this.dflt.equals(this.value);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsString {
        public int lines() default 1;

        public String dflt() default "";

        public boolean dfltIsNull() default false;

        public String profilesEdit() default "";
    }
}

