/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemInteger;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryLongFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryLongSwing;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EditorLong
extends EditorDefault<Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorLong.class.getName());
    private long min;
    private long max;
    private Long dflt;
    private Long value;
    public Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactoryLongSwing factorySwing;
    private FactoryLongFx factoryFx;

    public EditorLong() {
    }

    public EditorLong(long min2, long max, long deflt, String label, String description) {
        this.dflt = deflt;
        this.value = deflt;
        this.min = min2;
        this.max = max;
        this.setLabel(label);
        this.setDescription(description);
    }

    @Override
    public void initFor(Field field) {
        EdOptsLong annotation = field.getAnnotation(EdOptsLong.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdOptsLong annotation to use this editor: " + field.getName());
        }
        this.min = annotation.min();
        this.max = annotation.max();
        boolean isPrimitive = field.getType().isPrimitive();
        boolean dfltIsNull = annotation.dfltIsNull();
        if (dfltIsNull) {
            if (isPrimitive) {
                LOGGER.error("Flag dfltIsNull set to true on a primitive field: {}", (Object)field);
                this.dflt = 0L;
            }
        } else {
            this.dflt = annotation.dflt();
        }
        this.value = this.dflt;
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(annotation.profilesEdit());
    }

    @Override
    public void setConfig(JsonElement config) {
        this.value = config != null && config.isJsonPrimitive() && config.getAsJsonPrimitive().isNumber() ? Long.valueOf(config.getAsLong()) : this.dflt;
        this.fillComponent();
    }

    @Override
    public JsonElement getConfig() {
        Long val = this.getValue();
        if (val == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(val);
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemInteger item = (ItemInteger)((ItemInteger)((ItemInteger)new ItemInteger().setDeflt(this.dflt)).setTitle(this.getLabel())).setDescription(this.getDescription());
        if (this.min > Long.MIN_VALUE) {
            item.setMinimum(this.min);
        }
        if (this.max < Long.MAX_VALUE) {
            item.setMaximum(this.max);
        }
        if (rootSchema == null) {
            return new RootSchema(item);
        }
        return item;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryLongSwing(this);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryLongFx(this);
        }
        return this.factoryFx;
    }

    private void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    private void readComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.readComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.readComponent();
        }
    }

    public Long getRawValue() {
        return this.value;
    }

    public void setRawValue(long value) {
        if (value < this.min) {
            value = this.min;
        }
        if (value > this.max) {
            value = this.max;
        }
        this.value = value;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public Long getDeflt() {
        return this.dflt;
    }

    @Override
    public Long getValue() {
        this.readComponent();
        if (this.value == null) {
            return null;
        }
        if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
        return this.value;
    }

    @Override
    public void setValue(Long value) {
        this.value = value;
        this.fillComponent();
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
        this.fillComponent();
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile);
    }

    @Override
    public boolean isDefault() {
        this.readComponent();
        return this.dflt == this.value;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsLong {
        public long min() default -9223372036854775808L;

        public long max() default 0x7FFFFFFFFFFFFFFFL;

        public long dflt() default 0L;

        public boolean dfltIsNull() default false;

        public String profilesEdit() default "";
    }
}

