/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.technique;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.util.Stopwatch;
import com.vividsolutions.jtsexample.technique.PreparedGeometryIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchUsingPreparedGeometryIndex {
    static GeometryFactory geomFact = new GeometryFactory();
    static final int MAX_ITER = 200000;
    static final int GRID_SIZE = 10;
    static final int POLYGON_SIZE = 100;

    public static void main(String[] args) throws Exception {
        List circleGrid = SearchUsingPreparedGeometryIndex.createCircleGrid(10);
        PreparedGeometryIndex pgIndex = new PreparedGeometryIndex();
        pgIndex.insert(circleGrid);
        Stopwatch sw = new Stopwatch();
        int inCount = SearchUsingPreparedGeometryIndex.runIndexedQuery(pgIndex);
        String indexTime = sw.getTimeString();
        System.out.println("Number of iterations       = 200000");
        System.out.println("Number of circles in grid  = " + circleGrid.size());
        System.out.println();
        System.out.println("The fraction of intersecting points should approximate the total area of the circles:");
        System.out.println();
        System.out.println("Area of circles                = " + SearchUsingPreparedGeometryIndex.area(circleGrid));
        System.out.println("Fraction of points in circles  = " + (double)inCount / 200000.0);
        System.out.println();
        System.out.println("Indexed Execution time: " + indexTime);
        Stopwatch sw2 = new Stopwatch();
        int inCount2 = SearchUsingPreparedGeometryIndex.runBruteForceQuery(circleGrid);
        String bruteForceTime = sw2.getTimeString();
        System.out.println();
        System.out.println("Execution time: " + bruteForceTime);
    }

    static int runIndexedQuery(PreparedGeometryIndex pgIndex) {
        int inCount = 0;
        for (int i2 = 0; i2 < 200000; ++i2) {
            Point randPt = SearchUsingPreparedGeometryIndex.createRandomPoint();
            if (pgIndex.intersects(randPt).size() <= 0) continue;
            ++inCount;
        }
        return inCount;
    }

    static int runBruteForceQuery(Collection geoms) {
        int inCount = 0;
        for (int i2 = 0; i2 < 200000; ++i2) {
            Point randPt = SearchUsingPreparedGeometryIndex.createRandomPoint();
            if (SearchUsingPreparedGeometryIndex.findIntersecting(geoms, randPt).size() <= 0) continue;
            ++inCount;
        }
        return inCount;
    }

    static double area(Collection geoms) {
        double area = 0.0;
        for (Geometry geom : geoms) {
            area += geom.getArea();
        }
        return area;
    }

    static List createCircleGrid(int gridSize) {
        double diameter = 1.0 / (double)gridSize;
        double radius = diameter / 2.0;
        ArrayList<Geometry> circles = new ArrayList<Geometry>();
        for (int i2 = 0; i2 < gridSize; ++i2) {
            for (int j2 = 0; j2 < gridSize; ++j2) {
                Coordinate centre = new Coordinate(radius + (double)i2 * diameter, radius + (double)j2 * diameter);
                Geometry circle = SearchUsingPreparedGeometryIndex.createCircle(centre, radius);
                circles.add(circle);
            }
        }
        return circles;
    }

    static Geometry createCircle(Coordinate centre, double radius) {
        Point centrePt = geomFact.createPoint(centre);
        return centrePt.buffer(radius, 100);
    }

    static Point createRandomPoint() {
        return geomFact.createPoint(new Coordinate(Math.random(), Math.random()));
    }

    static List findIntersecting(Collection targetGeoms, Geometry queryGeom) {
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        for (Geometry test : targetGeoms) {
            if (!test.intersects(queryGeom)) continue;
            result.add(test);
        }
        return result;
    }
}

