/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate.quadedge;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.triangulate.quadedge.LastFoundQuadEdgeLocator;
import com.vividsolutions.jts.triangulate.quadedge.LocateFailureException;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeLocator;
import com.vividsolutions.jts.triangulate.quadedge.TriangleVisitor;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class QuadEdgeSubdivision {
    private static final double EDGE_COINCIDENCE_TOL_FACTOR = 1000.0;
    private int visitedKey = 0;
    private List quadEdges = new ArrayList();
    private QuadEdge startingEdge;
    private double tolerance;
    private double edgeCoincidenceTolerance;
    private Vertex[] frameVertex = new Vertex[3];
    private Envelope frameEnv;
    private QuadEdgeLocator locator = null;
    private LineSegment seg = new LineSegment();
    private QuadEdge[] triEdges = new QuadEdge[3];

    public static void getTriangleEdges(QuadEdge startQE, QuadEdge[] triEdge) {
        triEdge[0] = startQE;
        triEdge[1] = triEdge[0].lNext();
        triEdge[2] = triEdge[1].lNext();
        if (triEdge[2].lNext() != triEdge[0]) {
            throw new IllegalArgumentException("Edges do not form a triangle");
        }
    }

    public QuadEdgeSubdivision(Envelope env, double tolerance) {
        this.tolerance = tolerance;
        this.edgeCoincidenceTolerance = tolerance / 1000.0;
        this.createFrame(env);
        this.startingEdge = this.initSubdiv();
        this.locator = new LastFoundQuadEdgeLocator(this);
    }

    private void createFrame(Envelope env) {
        double deltaX = env.getWidth();
        double deltaY = env.getHeight();
        double offset = 0.0;
        offset = deltaX > deltaY ? deltaX * 10.0 : deltaY * 10.0;
        this.frameVertex[0] = new Vertex((env.getMaxX() + env.getMinX()) / 2.0, env.getMaxY() + offset);
        this.frameVertex[1] = new Vertex(env.getMinX() - offset, env.getMinY() - offset);
        this.frameVertex[2] = new Vertex(env.getMaxX() + offset, env.getMinY() - offset);
        this.frameEnv = new Envelope(this.frameVertex[0].getCoordinate(), this.frameVertex[1].getCoordinate());
        this.frameEnv.expandToInclude(this.frameVertex[2].getCoordinate());
    }

    private QuadEdge initSubdiv() {
        QuadEdge ea2 = this.makeEdge(this.frameVertex[0], this.frameVertex[1]);
        QuadEdge eb2 = this.makeEdge(this.frameVertex[1], this.frameVertex[2]);
        QuadEdge.splice(ea2.sym(), eb2);
        QuadEdge ec2 = this.makeEdge(this.frameVertex[2], this.frameVertex[0]);
        QuadEdge.splice(eb2.sym(), ec2);
        QuadEdge.splice(ec2.sym(), ea2);
        return ea2;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public Envelope getEnvelope() {
        return new Envelope(this.frameEnv);
    }

    public Collection getEdges() {
        return this.quadEdges;
    }

    public void setLocator(QuadEdgeLocator locator) {
        this.locator = locator;
    }

    public QuadEdge makeEdge(Vertex o2, Vertex d2) {
        QuadEdge q2 = QuadEdge.makeEdge(o2, d2);
        this.quadEdges.add(q2);
        return q2;
    }

    public QuadEdge connect(QuadEdge a2, QuadEdge b2) {
        QuadEdge q2 = QuadEdge.connect(a2, b2);
        this.quadEdges.add(q2);
        return q2;
    }

    public void delete(QuadEdge e2) {
        QuadEdge.splice(e2, e2.oPrev());
        QuadEdge.splice(e2.sym(), e2.sym().oPrev());
        QuadEdge eSym = e2.sym();
        QuadEdge eRot = e2.rot();
        QuadEdge eRotSym = e2.rot().sym();
        this.quadEdges.remove(e2);
        this.quadEdges.remove(eSym);
        this.quadEdges.remove(eRot);
        this.quadEdges.remove(eRotSym);
        e2.delete();
        eSym.delete();
        eRot.delete();
        eRotSym.delete();
    }

    public QuadEdge locateFromEdge(Vertex v2, QuadEdge startEdge) {
        int iter = 0;
        int maxIter = this.quadEdges.size();
        QuadEdge e2 = startEdge;
        while (true) {
            if (++iter > maxIter) {
                throw new LocateFailureException(e2.toLineSegment());
            }
            if (v2.equals(e2.orig()) || v2.equals(e2.dest())) break;
            if (v2.rightOf(e2)) {
                e2 = e2.sym();
                continue;
            }
            if (!v2.rightOf(e2.oNext())) {
                e2 = e2.oNext();
                continue;
            }
            if (v2.rightOf(e2.dPrev())) break;
            e2 = e2.dPrev();
        }
        return e2;
    }

    public QuadEdge locate(Vertex v2) {
        return this.locator.locate(v2);
    }

    public QuadEdge locate(Coordinate p2) {
        return this.locator.locate(new Vertex(p2));
    }

    public QuadEdge locate(Coordinate p0, Coordinate p1) {
        QuadEdge e2 = this.locator.locate(new Vertex(p0));
        if (e2 == null) {
            return null;
        }
        QuadEdge base = e2;
        if (e2.dest().getCoordinate().equals2D(p0)) {
            base = e2.sym();
        }
        QuadEdge locEdge = base;
        do {
            if (!locEdge.dest().getCoordinate().equals2D(p1)) continue;
            return locEdge;
        } while ((locEdge = locEdge.oNext()) != base);
        return null;
    }

    public QuadEdge insertSite(Vertex v2) {
        QuadEdge e2 = this.locate(v2);
        if (v2.equals(e2.orig(), this.tolerance) || v2.equals(e2.dest(), this.tolerance)) {
            return e2;
        }
        QuadEdge base = this.makeEdge(e2.orig(), v2);
        QuadEdge.splice(base, e2);
        QuadEdge startEdge = base;
        while ((e2 = (base = this.connect(e2, base.sym())).oPrev()).lNext() != startEdge) {
        }
        return startEdge;
    }

    public boolean isFrameEdge(QuadEdge e2) {
        return this.isFrameVertex(e2.orig()) || this.isFrameVertex(e2.dest());
    }

    public boolean isFrameBorderEdge(QuadEdge e2) {
        QuadEdge[] leftTri = new QuadEdge[3];
        QuadEdgeSubdivision.getTriangleEdges(e2, leftTri);
        QuadEdge[] rightTri = new QuadEdge[3];
        QuadEdgeSubdivision.getTriangleEdges(e2.sym(), rightTri);
        Vertex vLeftTriOther = e2.lNext().dest();
        if (this.isFrameVertex(vLeftTriOther)) {
            return true;
        }
        Vertex vRightTriOther = e2.sym().lNext().dest();
        return this.isFrameVertex(vRightTriOther);
    }

    public boolean isFrameVertex(Vertex v2) {
        if (v2.equals(this.frameVertex[0])) {
            return true;
        }
        if (v2.equals(this.frameVertex[1])) {
            return true;
        }
        return v2.equals(this.frameVertex[2]);
    }

    public boolean isOnEdge(QuadEdge e2, Coordinate p2) {
        this.seg.setCoordinates(e2.orig().getCoordinate(), e2.dest().getCoordinate());
        double dist = this.seg.distance(p2);
        return dist < this.edgeCoincidenceTolerance;
    }

    public boolean isVertexOfEdge(QuadEdge e2, Vertex v2) {
        return v2.equals(e2.orig(), this.tolerance) || v2.equals(e2.dest(), this.tolerance);
    }

    public Collection getVertices(boolean includeFrame) {
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        for (QuadEdge qe : this.quadEdges) {
            Vertex v2 = qe.orig();
            if (includeFrame || !this.isFrameVertex(v2)) {
                vertices.add(v2);
            }
            Vertex vd = qe.dest();
            if (!includeFrame && this.isFrameVertex(vd)) continue;
            vertices.add(vd);
        }
        return vertices;
    }

    public List getVertexUniqueEdges(boolean includeFrame) {
        ArrayList<QuadEdge> edges = new ArrayList<QuadEdge>();
        HashSet<Vertex> visitedVertices = new HashSet<Vertex>();
        for (QuadEdge qe : this.quadEdges) {
            QuadEdge qd;
            Vertex vd;
            Vertex v2 = qe.orig();
            if (!visitedVertices.contains(v2)) {
                visitedVertices.add(v2);
                if (includeFrame || !this.isFrameVertex(v2)) {
                    edges.add(qe);
                }
            }
            if (visitedVertices.contains(vd = (qd = qe.sym()).orig())) continue;
            visitedVertices.add(vd);
            if (!includeFrame && this.isFrameVertex(vd)) continue;
            edges.add(qd);
        }
        return edges;
    }

    public List getPrimaryEdges(boolean includeFrame) {
        ++this.visitedKey;
        ArrayList<QuadEdge> edges = new ArrayList<QuadEdge>();
        Stack<QuadEdge> edgeStack = new Stack<QuadEdge>();
        edgeStack.push(this.startingEdge);
        HashSet<QuadEdge> visitedEdges = new HashSet<QuadEdge>();
        while (!edgeStack.empty()) {
            QuadEdge edge = (QuadEdge)edgeStack.pop();
            if (visitedEdges.contains(edge)) continue;
            QuadEdge priQE = edge.getPrimary();
            if (includeFrame || !this.isFrameEdge(priQE)) {
                edges.add(priQE);
            }
            edgeStack.push(edge.oNext());
            edgeStack.push(edge.sym().oNext());
            visitedEdges.add(edge);
            visitedEdges.add(edge.sym());
        }
        return edges;
    }

    public void visitTriangles(TriangleVisitor triVisitor, boolean includeFrame) {
        ++this.visitedKey;
        Stack<QuadEdge> edgeStack = new Stack<QuadEdge>();
        edgeStack.push(this.startingEdge);
        HashSet visitedEdges = new HashSet();
        while (!edgeStack.empty()) {
            QuadEdge[] triEdges;
            QuadEdge edge = (QuadEdge)edgeStack.pop();
            if (visitedEdges.contains(edge) || (triEdges = this.fetchTriangleToVisit(edge, edgeStack, includeFrame, visitedEdges)) == null) continue;
            triVisitor.visit(triEdges);
        }
    }

    private QuadEdge[] fetchTriangleToVisit(QuadEdge edge, Stack edgeStack, boolean includeFrame, Set visitedEdges) {
        QuadEdge curr = edge;
        int edgeCount = 0;
        boolean isFrame = false;
        do {
            QuadEdge sym;
            this.triEdges[edgeCount] = curr;
            if (this.isFrameEdge(curr)) {
                isFrame = true;
            }
            if (!visitedEdges.contains(sym = curr.sym())) {
                edgeStack.push(sym);
            }
            visitedEdges.add(curr);
            ++edgeCount;
        } while ((curr = curr.lNext()) != edge);
        if (isFrame && !includeFrame) {
            return null;
        }
        return this.triEdges;
    }

    public List getTriangleEdges(boolean includeFrame) {
        TriangleEdgesListVisitor visitor = new TriangleEdgesListVisitor();
        this.visitTriangles(visitor, includeFrame);
        return visitor.getTriangleEdges();
    }

    public List getTriangleVertices(boolean includeFrame) {
        TriangleVertexListVisitor visitor = new TriangleVertexListVisitor();
        this.visitTriangles(visitor, includeFrame);
        return visitor.getTriangleVertices();
    }

    public List getTriangleCoordinates(boolean includeFrame) {
        TriangleCoordinatesVisitor visitor = new TriangleCoordinatesVisitor();
        this.visitTriangles(visitor, includeFrame);
        return visitor.getTriangles();
    }

    public Geometry getEdges(GeometryFactory geomFact) {
        List quadEdges = this.getPrimaryEdges(false);
        LineString[] edges = new LineString[quadEdges.size()];
        int i2 = 0;
        for (QuadEdge qe : quadEdges) {
            edges[i2++] = geomFact.createLineString(new Coordinate[]{qe.orig().getCoordinate(), qe.dest().getCoordinate()});
        }
        return geomFact.createMultiLineString(edges);
    }

    public Geometry getTriangles(GeometryFactory geomFact) {
        List triPtsList = this.getTriangleCoordinates(false);
        Geometry[] tris = new Polygon[triPtsList.size()];
        int i2 = 0;
        for (Coordinate[] triPt : triPtsList) {
            tris[i2++] = geomFact.createPolygon(geomFact.createLinearRing(triPt), null);
        }
        return geomFact.createGeometryCollection(tris);
    }

    public Geometry getVoronoiDiagram(GeometryFactory geomFact) {
        List vorCells = this.getVoronoiCellPolygons(geomFact);
        return geomFact.createGeometryCollection(GeometryFactory.toGeometryArray(vorCells));
    }

    public List getVoronoiCellPolygons(GeometryFactory geomFact) {
        this.visitTriangles(new TriangleCircumcentreVisitor(), true);
        ArrayList<Polygon> cells = new ArrayList<Polygon>();
        List edges = this.getVertexUniqueEdges(false);
        for (QuadEdge qe : edges) {
            cells.add(this.getVoronoiCellPolygon(qe, geomFact));
        }
        return cells;
    }

    public Polygon getVoronoiCellPolygon(QuadEdge qe, GeometryFactory geomFact) {
        ArrayList<Coordinate> cellPts = new ArrayList<Coordinate>();
        QuadEdge startQE = qe;
        do {
            Coordinate cc2 = qe.rot().orig().getCoordinate();
            cellPts.add(cc2);
        } while ((qe = qe.oPrev()) != startQE);
        CoordinateList coordList = new CoordinateList();
        coordList.addAll(cellPts, false);
        coordList.closeRing();
        if (coordList.size() < 4) {
            System.out.println(coordList);
            coordList.add(coordList.get(coordList.size() - 1), true);
        }
        Coordinate[] pts = coordList.toCoordinateArray();
        Polygon cellPoly = geomFact.createPolygon(geomFact.createLinearRing(pts), null);
        Vertex v2 = startQE.orig();
        cellPoly.setUserData(v2.getCoordinate());
        return cellPoly;
    }

    private static class TriangleCoordinatesVisitor
    implements TriangleVisitor {
        private CoordinateList coordList = new CoordinateList();
        private List triCoords = new ArrayList();

        public void visit(QuadEdge[] triEdges) {
            this.coordList.clear();
            for (int i2 = 0; i2 < 3; ++i2) {
                Vertex v2 = triEdges[i2].orig();
                this.coordList.add(v2.getCoordinate());
            }
            if (this.coordList.size() > 0) {
                this.coordList.closeRing();
                Coordinate[] pts = this.coordList.toCoordinateArray();
                if (pts.length != 4) {
                    return;
                }
                this.triCoords.add(pts);
            }
        }

        private void checkTriangleSize(Coordinate[] pts) {
            String loc = "";
            if (pts.length >= 2) {
                loc = WKTWriter.toLineString(pts[0], pts[1]);
            } else if (pts.length >= 1) {
                loc = WKTWriter.toPoint(pts[0]);
            }
        }

        public List getTriangles() {
            return this.triCoords;
        }
    }

    private static class TriangleVertexListVisitor
    implements TriangleVisitor {
        private List triList = new ArrayList();

        private TriangleVertexListVisitor() {
        }

        public void visit(QuadEdge[] triEdges) {
            this.triList.add(new Vertex[]{triEdges[0].orig(), triEdges[1].orig(), triEdges[2].orig()});
        }

        public List getTriangleVertices() {
            return this.triList;
        }
    }

    private static class TriangleEdgesListVisitor
    implements TriangleVisitor {
        private List triList = new ArrayList();

        private TriangleEdgesListVisitor() {
        }

        public void visit(QuadEdge[] triEdges) {
            this.triList.add(triEdges.clone());
        }

        public List getTriangleEdges() {
            return this.triList;
        }
    }

    private static class TriangleCircumcentreVisitor
    implements TriangleVisitor {
        public void visit(QuadEdge[] triEdges) {
            Coordinate a2 = triEdges[0].orig().getCoordinate();
            Coordinate b2 = triEdges[1].orig().getCoordinate();
            Coordinate c2 = triEdges[2].orig().getCoordinate();
            Coordinate cc2 = Triangle.circumcentre(a2, b2, c2);
            Vertex ccVertex = new Vertex(cc2);
            for (int i2 = 0; i2 < 3; ++i2) {
                triEdges[i2].rot().setOrig(ccVertex);
            }
        }
    }
}

