/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.triangulate.DelaunayTriangulationBuilder;
import com.vividsolutions.jts.triangulate.IncrementalDelaunayTriangulator;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VoronoiDiagramBuilder {
    private Collection siteCoords;
    private double tolerance = 0.0;
    private QuadEdgeSubdivision subdiv = null;
    private Envelope clipEnv = null;
    private Envelope diagramEnv = null;

    public void setSites(Geometry geom) {
        this.siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(geom);
    }

    public void setSites(Collection coords) {
        this.siteCoords = DelaunayTriangulationBuilder.unique(CoordinateArrays.toCoordinateArray(coords));
    }

    public void setClipEnvelope(Envelope clipEnv) {
        this.clipEnv = clipEnv;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private void create() {
        Envelope siteEnv;
        if (this.subdiv != null) {
            return;
        }
        this.diagramEnv = siteEnv = DelaunayTriangulationBuilder.envelope(this.siteCoords);
        double expandBy = Math.max(this.diagramEnv.getWidth(), this.diagramEnv.getHeight());
        this.diagramEnv.expandBy(expandBy);
        if (this.clipEnv != null) {
            this.diagramEnv.expandToInclude(this.clipEnv);
        }
        List vertices = DelaunayTriangulationBuilder.toVertices(this.siteCoords);
        this.subdiv = new QuadEdgeSubdivision(siteEnv, this.tolerance);
        IncrementalDelaunayTriangulator triangulator = new IncrementalDelaunayTriangulator(this.subdiv);
        triangulator.insertSites(vertices);
    }

    public QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    public Geometry getDiagram(GeometryFactory geomFact) {
        this.create();
        Geometry polys = this.subdiv.getVoronoiDiagram(geomFact);
        return VoronoiDiagramBuilder.clipGeometryCollection(polys, this.diagramEnv);
    }

    private static Geometry clipGeometryCollection(Geometry geom, Envelope clipEnv) {
        Geometry clipPoly = geom.getFactory().toGeometry(clipEnv);
        ArrayList<Geometry> clipped = new ArrayList<Geometry>();
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Geometry g2 = geom.getGeometryN(i2);
            Geometry result = null;
            if (clipEnv.contains(g2.getEnvelopeInternal())) {
                result = g2;
            } else if (clipEnv.intersects(g2.getEnvelopeInternal())) {
                result = clipPoly.intersection(g2);
                result.setUserData(g2.getUserData());
            }
            if (result == null || result.isEmpty()) continue;
            clipped.add(result);
        }
        return geom.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(clipped));
    }
}

