/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph.algorithm;

import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.PlanarGraph;
import com.vividsolutions.jts.planargraph.Subgraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ConnectedSubgraphFinder {
    private PlanarGraph graph;

    public ConnectedSubgraphFinder(PlanarGraph graph) {
        this.graph = graph;
    }

    public List getConnectedSubgraphs() {
        ArrayList<Subgraph> subgraphs = new ArrayList<Subgraph>();
        GraphComponent.setVisited(this.graph.nodeIterator(), false);
        Iterator i2 = this.graph.edgeIterator();
        while (i2.hasNext()) {
            Edge e2 = (Edge)i2.next();
            Node node = e2.getDirEdge(0).getFromNode();
            if (node.isVisited()) continue;
            subgraphs.add(this.findSubgraph(node));
        }
        return subgraphs;
    }

    private Subgraph findSubgraph(Node node) {
        Subgraph subgraph = new Subgraph(this.graph);
        this.addReachable(node, subgraph);
        return subgraph;
    }

    private void addReachable(Node startNode, Subgraph subgraph) {
        Stack<Node> nodeStack = new Stack<Node>();
        nodeStack.add(startNode);
        while (!nodeStack.empty()) {
            Node node = (Node)nodeStack.pop();
            this.addEdges(node, nodeStack, subgraph);
        }
    }

    private void addEdges(Node node, Stack nodeStack, Subgraph subgraph) {
        node.setVisited(true);
        Iterator i2 = node.getOutEdges().iterator();
        while (i2.hasNext()) {
            DirectedEdge de2 = (DirectedEdge)i2.next();
            subgraph.add(de2.getEdge());
            Node toNode = de2.getToNode();
            if (toNode.isVisited()) continue;
            nodeStack.push(toNode);
        }
    }
}

