/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.union;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.geom.util.GeometryExtracter;
import com.vividsolutions.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import com.vividsolutions.jts.operation.union.CascadedPolygonUnion;
import com.vividsolutions.jts.operation.union.PointGeometryUnion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnaryUnionOp {
    private List polygons = new ArrayList();
    private List lines = new ArrayList();
    private List points = new ArrayList();
    private GeometryFactory geomFact = null;

    public static Geometry union(Collection geoms) {
        UnaryUnionOp op2 = new UnaryUnionOp(geoms);
        return op2.union();
    }

    public static Geometry union(Collection geoms, GeometryFactory geomFact) {
        UnaryUnionOp op2 = new UnaryUnionOp(geoms, geomFact);
        return op2.union();
    }

    public static Geometry union(Geometry geom) {
        UnaryUnionOp op2 = new UnaryUnionOp(geom);
        return op2.union();
    }

    public UnaryUnionOp(Collection geoms, GeometryFactory geomFact) {
        this.geomFact = geomFact;
        this.extract(geoms);
    }

    public UnaryUnionOp(Collection geoms) {
        this.extract(geoms);
    }

    public UnaryUnionOp(Geometry geom) {
        this.extract(geom);
    }

    private void extract(Collection geoms) {
        for (Geometry geom : geoms) {
            this.extract(geom);
        }
    }

    private void extract(Geometry geom) {
        if (this.geomFact == null) {
            this.geomFact = geom.getFactory();
        }
        GeometryExtracter.extract(geom, Polygon.class, this.polygons);
        GeometryExtracter.extract(geom, LineString.class, this.lines);
        GeometryExtracter.extract(geom, Point.class, this.points);
    }

    public Geometry union() {
        if (this.geomFact == null) {
            return null;
        }
        Geometry unionPoints = null;
        if (this.points.size() > 0) {
            Geometry ptGeom = this.geomFact.buildGeometry(this.points);
            unionPoints = this.unionNoOpt(ptGeom);
        }
        Geometry unionLines = null;
        if (this.lines.size() > 0) {
            Geometry lineGeom = this.geomFact.buildGeometry(this.lines);
            unionLines = this.unionNoOpt(lineGeom);
        }
        Geometry unionPolygons = null;
        if (this.polygons.size() > 0) {
            unionPolygons = CascadedPolygonUnion.union(this.polygons);
        }
        Geometry unionLA = this.unionWithNull(unionLines, unionPolygons);
        Geometry union = null;
        union = unionPoints == null ? unionLA : (unionLA == null ? unionPoints : PointGeometryUnion.union((Puntal)((Object)unionPoints), unionLA));
        if (union == null) {
            return this.geomFact.createGeometryCollection(null);
        }
        return union;
    }

    private Geometry unionWithNull(Geometry g0, Geometry g1) {
        if (g0 == null && g1 == null) {
            return null;
        }
        if (g1 == null) {
            return g0;
        }
        if (g0 == null) {
            return g1;
        }
        return g0.union(g1);
    }

    private Geometry unionNoOpt(Geometry g0) {
        Point empty = this.geomFact.createPoint((Coordinate)null);
        return SnapIfNeededOverlayOp.overlayOp(g0, empty, 2);
    }
}

