/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.union;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.geom.util.GeometryCombiner;
import java.util.TreeSet;

public class PointGeometryUnion {
    private Geometry pointGeom;
    private Geometry otherGeom;
    private GeometryFactory geomFact;

    public static Geometry union(Puntal pointGeom, Geometry otherGeom) {
        PointGeometryUnion unioner = new PointGeometryUnion(pointGeom, otherGeom);
        return unioner.union();
    }

    public PointGeometryUnion(Puntal pointGeom, Geometry otherGeom) {
        this.pointGeom = (Geometry)((Object)pointGeom);
        this.otherGeom = otherGeom;
        this.geomFact = otherGeom.getFactory();
    }

    public Geometry union() {
        PointLocator locater = new PointLocator();
        TreeSet<Coordinate> exteriorCoords = new TreeSet<Coordinate>();
        for (int i2 = 0; i2 < this.pointGeom.getNumGeometries(); ++i2) {
            Point point = (Point)this.pointGeom.getGeometryN(i2);
            Coordinate coord = point.getCoordinate();
            int loc = locater.locate(coord, this.otherGeom);
            if (loc != 2) continue;
            exteriorCoords.add(coord);
        }
        if (exteriorCoords.size() == 0) {
            return this.otherGeom;
        }
        Geometry ptComp = null;
        Coordinate[] coords = CoordinateArrays.toCoordinateArray(exteriorCoords);
        ptComp = coords.length == 1 ? this.geomFact.createPoint(coords[0]) : this.geomFact.createMultiPoint(coords);
        return GeometryCombiner.combine(ptComp, this.otherGeom);
    }
}

