/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeMap;
import com.vividsolutions.jts.operation.relate.EdgeEndBuilder;
import com.vividsolutions.jts.operation.relate.RelateNode;
import com.vividsolutions.jts.operation.relate.RelateNodeFactory;
import java.util.Iterator;
import java.util.List;

public class RelateNodeGraph {
    private NodeMap nodes = new NodeMap(new RelateNodeFactory());

    public Iterator getNodeIterator() {
        return this.nodes.iterator();
    }

    public void build(GeometryGraph geomGraph) {
        this.computeIntersectionNodes(geomGraph, 0);
        this.copyNodesAndLabels(geomGraph, 0);
        EdgeEndBuilder eeBuilder = new EdgeEndBuilder();
        List eeList = eeBuilder.computeEdgeEnds(geomGraph.getEdgeIterator());
        this.insertEdgeEnds(eeList);
    }

    public void computeIntersectionNodes(GeometryGraph geomGraph, int argIndex) {
        Iterator edgeIt = geomGraph.getEdgeIterator();
        while (edgeIt.hasNext()) {
            Edge e2 = (Edge)edgeIt.next();
            int eLoc = e2.getLabel().getLocation(argIndex);
            Iterator eiIt = e2.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei2 = (EdgeIntersection)eiIt.next();
                RelateNode n2 = (RelateNode)this.nodes.addNode(ei2.coord);
                if (eLoc == 1) {
                    n2.setLabelBoundary(argIndex);
                    continue;
                }
                if (!n2.getLabel().isNull(argIndex)) continue;
                n2.setLabel(argIndex, 0);
            }
        }
    }

    public void copyNodesAndLabels(GeometryGraph geomGraph, int argIndex) {
        Iterator nodeIt = geomGraph.getNodeIterator();
        while (nodeIt.hasNext()) {
            Node graphNode = (Node)nodeIt.next();
            Node newNode = this.nodes.addNode(graphNode.getCoordinate());
            newNode.setLabel(argIndex, graphNode.getLabel().getLocation(argIndex));
        }
    }

    public void insertEdgeEnds(List ee2) {
        for (EdgeEnd e2 : ee2) {
            this.nodes.add(e2);
        }
    }
}

