/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.relate;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeMap;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import com.vividsolutions.jts.operation.relate.EdgeEndBuilder;
import com.vividsolutions.jts.operation.relate.RelateNode;
import com.vividsolutions.jts.operation.relate.RelateNodeFactory;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RelateComputer {
    private LineIntersector li = new RobustLineIntersector();
    private PointLocator ptLocator = new PointLocator();
    private GeometryGraph[] arg;
    private NodeMap nodes = new NodeMap(new RelateNodeFactory());
    private IntersectionMatrix im = null;
    private ArrayList isolatedEdges = new ArrayList();
    private Coordinate invalidPoint;

    public RelateComputer(GeometryGraph[] arg) {
        this.arg = arg;
    }

    public IntersectionMatrix computeIM() {
        IntersectionMatrix im2 = new IntersectionMatrix();
        im2.set(2, 2, 2);
        if (!this.arg[0].getGeometry().getEnvelopeInternal().intersects(this.arg[1].getGeometry().getEnvelopeInternal())) {
            this.computeDisjointIM(im2);
            return im2;
        }
        this.arg[0].computeSelfNodes(this.li, false);
        this.arg[1].computeSelfNodes(this.li, false);
        SegmentIntersector intersector = this.arg[0].computeEdgeIntersections(this.arg[1], this.li, false);
        this.computeIntersectionNodes(0);
        this.computeIntersectionNodes(1);
        this.copyNodesAndLabels(0);
        this.copyNodesAndLabels(1);
        this.labelIsolatedNodes();
        this.computeProperIntersectionIM(intersector, im2);
        EdgeEndBuilder eeBuilder = new EdgeEndBuilder();
        List ee0 = eeBuilder.computeEdgeEnds(this.arg[0].getEdgeIterator());
        this.insertEdgeEnds(ee0);
        List ee1 = eeBuilder.computeEdgeEnds(this.arg[1].getEdgeIterator());
        this.insertEdgeEnds(ee1);
        this.labelNodeEdges();
        this.labelIsolatedEdges(0, 1);
        this.labelIsolatedEdges(1, 0);
        this.updateIM(im2);
        return im2;
    }

    private void insertEdgeEnds(List ee2) {
        for (EdgeEnd e2 : ee2) {
            this.nodes.add(e2);
        }
    }

    private void computeProperIntersectionIM(SegmentIntersector intersector, IntersectionMatrix im2) {
        int dimA = this.arg[0].getGeometry().getDimension();
        int dimB = this.arg[1].getGeometry().getDimension();
        boolean hasProper = intersector.hasProperIntersection();
        boolean hasProperInterior = intersector.hasProperInteriorIntersection();
        if (dimA == 2 && dimB == 2) {
            if (hasProper) {
                im2.setAtLeast("212101212");
            }
        } else if (dimA == 2 && dimB == 1) {
            if (hasProper) {
                im2.setAtLeast("FFF0FFFF2");
            }
            if (hasProperInterior) {
                im2.setAtLeast("1FFFFF1FF");
            }
        } else if (dimA == 1 && dimB == 2) {
            if (hasProper) {
                im2.setAtLeast("F0FFFFFF2");
            }
            if (hasProperInterior) {
                im2.setAtLeast("1F1FFFFFF");
            }
        } else if (dimA == 1 && dimB == 1 && hasProperInterior) {
            im2.setAtLeast("0FFFFFFFF");
        }
    }

    private void copyNodesAndLabels(int argIndex) {
        Iterator i2 = this.arg[argIndex].getNodeIterator();
        while (i2.hasNext()) {
            Node graphNode = (Node)i2.next();
            Node newNode = this.nodes.addNode(graphNode.getCoordinate());
            newNode.setLabel(argIndex, graphNode.getLabel().getLocation(argIndex));
        }
    }

    private void computeIntersectionNodes(int argIndex) {
        Iterator i2 = this.arg[argIndex].getEdgeIterator();
        while (i2.hasNext()) {
            Edge e2 = (Edge)i2.next();
            int eLoc = e2.getLabel().getLocation(argIndex);
            Iterator eiIt = e2.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei2 = (EdgeIntersection)eiIt.next();
                RelateNode n2 = (RelateNode)this.nodes.addNode(ei2.coord);
                if (eLoc == 1) {
                    n2.setLabelBoundary(argIndex);
                    continue;
                }
                if (!n2.getLabel().isNull(argIndex)) continue;
                n2.setLabel(argIndex, 0);
            }
        }
    }

    private void labelIntersectionNodes(int argIndex) {
        Iterator i2 = this.arg[argIndex].getEdgeIterator();
        while (i2.hasNext()) {
            Edge e2 = (Edge)i2.next();
            int eLoc = e2.getLabel().getLocation(argIndex);
            Iterator eiIt = e2.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei2 = (EdgeIntersection)eiIt.next();
                RelateNode n2 = (RelateNode)this.nodes.find(ei2.coord);
                if (!n2.getLabel().isNull(argIndex)) continue;
                if (eLoc == 1) {
                    n2.setLabelBoundary(argIndex);
                    continue;
                }
                n2.setLabel(argIndex, 0);
            }
        }
    }

    private void computeDisjointIM(IntersectionMatrix im2) {
        Geometry gb2;
        Geometry ga2 = this.arg[0].getGeometry();
        if (!ga2.isEmpty()) {
            im2.set(0, 2, ga2.getDimension());
            im2.set(1, 2, ga2.getBoundaryDimension());
        }
        if (!(gb2 = this.arg[1].getGeometry()).isEmpty()) {
            im2.set(2, 0, gb2.getDimension());
            im2.set(2, 1, gb2.getBoundaryDimension());
        }
    }

    private void labelNodeEdges() {
        Iterator ni2 = this.nodes.iterator();
        while (ni2.hasNext()) {
            RelateNode node = (RelateNode)ni2.next();
            node.getEdges().computeLabelling(this.arg);
        }
    }

    private void updateIM(IntersectionMatrix im2) {
        for (Edge e2 : this.isolatedEdges) {
            e2.updateIM(im2);
        }
        Iterator ni2 = this.nodes.iterator();
        while (ni2.hasNext()) {
            RelateNode node = (RelateNode)ni2.next();
            node.updateIM(im2);
            node.updateIMFromEdges(im2);
        }
    }

    private void labelIsolatedEdges(int thisIndex, int targetIndex) {
        Iterator ei2 = this.arg[thisIndex].getEdgeIterator();
        while (ei2.hasNext()) {
            Edge e2 = (Edge)ei2.next();
            if (!e2.isIsolated()) continue;
            this.labelIsolatedEdge(e2, targetIndex, this.arg[targetIndex].getGeometry());
            this.isolatedEdges.add(e2);
        }
    }

    private void labelIsolatedEdge(Edge e2, int targetIndex, Geometry target) {
        if (target.getDimension() > 0) {
            int loc = this.ptLocator.locate(e2.getCoordinate(), target);
            e2.getLabel().setAllLocations(targetIndex, loc);
        } else {
            e2.getLabel().setAllLocations(targetIndex, 2);
        }
    }

    private void labelIsolatedNodes() {
        Iterator ni2 = this.nodes.iterator();
        while (ni2.hasNext()) {
            Node n2 = (Node)ni2.next();
            Label label = n2.getLabel();
            Assert.isTrue(label.getGeometryCount() > 0, "node with empty label found");
            if (!n2.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedNode(n2, 0);
                continue;
            }
            this.labelIsolatedNode(n2, 1);
        }
    }

    private void labelIsolatedNode(Node n2, int targetIndex) {
        int loc = this.ptLocator.locate(n2.getCoordinate(), this.arg[targetIndex].getGeometry());
        n2.getLabel().setAllLocations(targetIndex, loc);
    }
}

