/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.validate;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.operation.overlay.validate.PolygonalLineworkExtracter;
import java.util.List;

public class FuzzyPointLocator {
    private Geometry g;
    private double boundaryDistanceTolerance;
    private MultiLineString linework;
    private PointLocator ptLocator = new PointLocator();
    private LineSegment seg = new LineSegment();

    public FuzzyPointLocator(Geometry g2, double boundaryDistanceTolerance) {
        this.g = g2;
        this.boundaryDistanceTolerance = boundaryDistanceTolerance;
        this.linework = this.extractLinework(g2);
    }

    public int getLocation(Coordinate pt2) {
        if (this.isWithinToleranceOfBoundary(pt2)) {
            return 1;
        }
        return this.ptLocator.locate(pt2, this.g);
    }

    private MultiLineString extractLinework(Geometry g2) {
        PolygonalLineworkExtracter extracter = new PolygonalLineworkExtracter();
        g2.apply(extracter);
        List linework = extracter.getLinework();
        LineString[] lines = GeometryFactory.toLineStringArray(linework);
        return g2.getFactory().createMultiLineString(lines);
    }

    private boolean isWithinToleranceOfBoundary(Coordinate pt2) {
        for (int i2 = 0; i2 < this.linework.getNumGeometries(); ++i2) {
            LineString line = (LineString)this.linework.getGeometryN(i2);
            CoordinateSequence seq = line.getCoordinateSequence();
            for (int j2 = 0; j2 < seq.size() - 1; ++j2) {
                seq.getCoordinate(j2, this.seg.p0);
                seq.getCoordinate(j2 + 1, this.seg.p1);
                double dist = this.seg.distance(pt2);
                if (!(dist <= this.boundaryDistanceTolerance)) continue;
                return true;
            }
        }
        return false;
    }
}

