/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.overlay.MaximalEdgeRing;
import com.vividsolutions.jts.operation.overlay.MinimalEdgeRing;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PolygonBuilder {
    private GeometryFactory geometryFactory;
    private List shellList = new ArrayList();

    public PolygonBuilder(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public void add(PlanarGraph graph) {
        this.add(graph.getEdgeEnds(), graph.getNodes());
    }

    public void add(Collection dirEdges, Collection nodes) {
        PlanarGraph.linkResultDirectedEdges(nodes);
        List maxEdgeRings = this.buildMaximalEdgeRings(dirEdges);
        ArrayList freeHoleList = new ArrayList();
        List edgeRings = this.buildMinimalEdgeRings(maxEdgeRings, this.shellList, freeHoleList);
        this.sortShellsAndHoles(edgeRings, this.shellList, freeHoleList);
        this.placeFreeHoles(this.shellList, freeHoleList);
    }

    public List getPolygons() {
        List resultPolyList = this.computePolygons(this.shellList);
        return resultPolyList;
    }

    private List buildMaximalEdgeRings(Collection dirEdges) {
        ArrayList<MaximalEdgeRing> maxEdgeRings = new ArrayList<MaximalEdgeRing>();
        for (DirectedEdge de2 : dirEdges) {
            if (!de2.isInResult() || !de2.getLabel().isArea() || de2.getEdgeRing() != null) continue;
            MaximalEdgeRing er2 = new MaximalEdgeRing(de2, this.geometryFactory);
            maxEdgeRings.add(er2);
            er2.setInResult();
        }
        return maxEdgeRings;
    }

    private List buildMinimalEdgeRings(List maxEdgeRings, List shellList, List freeHoleList) {
        ArrayList<MaximalEdgeRing> edgeRings = new ArrayList<MaximalEdgeRing>();
        for (MaximalEdgeRing er2 : maxEdgeRings) {
            if (er2.getMaxNodeDegree() > 2) {
                er2.linkDirectedEdgesForMinimalEdgeRings();
                List minEdgeRings = er2.buildMinimalRings();
                EdgeRing shell = this.findShell(minEdgeRings);
                if (shell != null) {
                    this.placePolygonHoles(shell, minEdgeRings);
                    shellList.add(shell);
                    continue;
                }
                freeHoleList.addAll(minEdgeRings);
                continue;
            }
            edgeRings.add(er2);
        }
        return edgeRings;
    }

    private EdgeRing findShell(List minEdgeRings) {
        int shellCount = 0;
        MinimalEdgeRing shell = null;
        for (MinimalEdgeRing er2 : minEdgeRings) {
            if (er2.isHole()) continue;
            shell = er2;
            ++shellCount;
        }
        Assert.isTrue(shellCount <= 1, "found two shells in MinimalEdgeRing list");
        return shell;
    }

    private void placePolygonHoles(EdgeRing shell, List minEdgeRings) {
        for (MinimalEdgeRing er2 : minEdgeRings) {
            if (!er2.isHole()) continue;
            er2.setShell(shell);
        }
    }

    private void sortShellsAndHoles(List edgeRings, List shellList, List freeHoleList) {
        for (EdgeRing er2 : edgeRings) {
            if (er2.isHole()) {
                freeHoleList.add(er2);
                continue;
            }
            shellList.add(er2);
        }
    }

    private void placeFreeHoles(List shellList, List freeHoleList) {
        for (EdgeRing hole : freeHoleList) {
            if (hole.getShell() != null) continue;
            EdgeRing shell = this.findEdgeRingContaining(hole, shellList);
            if (shell == null) {
                throw new TopologyException("unable to assign hole to a shell", hole.getCoordinate(0));
            }
            hole.setShell(shell);
        }
    }

    private EdgeRing findEdgeRingContaining(EdgeRing testEr, List shellList) {
        LinearRing testRing = testEr.getLinearRing();
        Envelope testEnv = testRing.getEnvelopeInternal();
        Coordinate testPt = testRing.getCoordinateN(0);
        EdgeRing minShell = null;
        Envelope minEnv = null;
        for (EdgeRing tryShell : shellList) {
            LinearRing tryRing = tryShell.getLinearRing();
            Envelope tryEnv = tryRing.getEnvelopeInternal();
            if (minShell != null) {
                minEnv = minShell.getLinearRing().getEnvelopeInternal();
            }
            boolean isContained = false;
            if (tryEnv.contains(testEnv) && CGAlgorithms.isPointInRing(testPt, tryRing.getCoordinates())) {
                isContained = true;
            }
            if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
            minShell = tryShell;
        }
        return minShell;
    }

    private List computePolygons(List shellList) {
        ArrayList<Polygon> resultPolyList = new ArrayList<Polygon>();
        for (EdgeRing er2 : shellList) {
            Polygon poly = er2.toPolygon(this.geometryFactory);
            resultPolyList.add(poly);
        }
        return resultPolyList;
    }

    public boolean containsPoint(Coordinate p2) {
        for (EdgeRing er2 : this.shellList) {
            if (!er2.containsPoint(p2)) continue;
            return true;
        }
        return false;
    }
}

