/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geomgraph.Depth;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeList;
import com.vividsolutions.jts.geomgraph.EdgeNodingValidator;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.GeometryGraphOperation;
import com.vividsolutions.jts.operation.overlay.LineBuilder;
import com.vividsolutions.jts.operation.overlay.OverlayNodeFactory;
import com.vividsolutions.jts.operation.overlay.PointBuilder;
import com.vividsolutions.jts.operation.overlay.PolygonBuilder;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OverlayOp
extends GeometryGraphOperation {
    public static final int INTERSECTION = 1;
    public static final int UNION = 2;
    public static final int DIFFERENCE = 3;
    public static final int SYMDIFFERENCE = 4;
    private final PointLocator ptLocator = new PointLocator();
    private GeometryFactory geomFact;
    private Geometry resultGeom;
    private PlanarGraph graph;
    private EdgeList edgeList = new EdgeList();
    private List resultPolyList = new ArrayList();
    private List resultLineList = new ArrayList();
    private List resultPointList = new ArrayList();

    public static Geometry overlayOp(Geometry geom0, Geometry geom1, int opCode) {
        OverlayOp gov = new OverlayOp(geom0, geom1);
        Geometry geomOv = gov.getResultGeometry(opCode);
        return geomOv;
    }

    public static boolean isResultOfOp(Label label, int opCode) {
        int loc0 = label.getLocation(0);
        int loc1 = label.getLocation(1);
        return OverlayOp.isResultOfOp(loc0, loc1, opCode);
    }

    public static boolean isResultOfOp(int loc0, int loc1, int opCode) {
        if (loc0 == 1) {
            loc0 = 0;
        }
        if (loc1 == 1) {
            loc1 = 0;
        }
        switch (opCode) {
            case 1: {
                return loc0 == 0 && loc1 == 0;
            }
            case 2: {
                return loc0 == 0 || loc1 == 0;
            }
            case 3: {
                return loc0 == 0 && loc1 != 0;
            }
            case 4: {
                return loc0 == 0 && loc1 != 0 || loc0 != 0 && loc1 == 0;
            }
        }
        return false;
    }

    public OverlayOp(Geometry g0, Geometry g1) {
        super(g0, g1);
        this.graph = new PlanarGraph(new OverlayNodeFactory());
        this.geomFact = g0.getFactory();
    }

    public Geometry getResultGeometry(int funcCode) {
        this.computeOverlay(funcCode);
        return this.resultGeom;
    }

    public PlanarGraph getGraph() {
        return this.graph;
    }

    private void computeOverlay(int opCode) {
        this.copyPoints(0);
        this.copyPoints(1);
        this.arg[0].computeSelfNodes(this.li, false);
        this.arg[1].computeSelfNodes(this.li, false);
        this.arg[0].computeEdgeIntersections(this.arg[1], this.li, true);
        ArrayList baseSplitEdges = new ArrayList();
        this.arg[0].computeSplitEdges(baseSplitEdges);
        this.arg[1].computeSplitEdges(baseSplitEdges);
        ArrayList splitEdges = baseSplitEdges;
        this.insertUniqueEdges(baseSplitEdges);
        this.computeLabelsFromDepths();
        this.replaceCollapsedEdges();
        EdgeNodingValidator.checkValid(this.edgeList.getEdges());
        this.graph.addEdges(this.edgeList.getEdges());
        this.computeLabelling();
        this.labelIncompleteNodes();
        this.findResultAreaEdges(opCode);
        this.cancelDuplicateResultEdges();
        PolygonBuilder polyBuilder = new PolygonBuilder(this.geomFact);
        polyBuilder.add(this.graph);
        this.resultPolyList = polyBuilder.getPolygons();
        LineBuilder lineBuilder = new LineBuilder(this, this.geomFact, this.ptLocator);
        this.resultLineList = lineBuilder.build(opCode);
        PointBuilder pointBuilder = new PointBuilder(this, this.geomFact, this.ptLocator);
        this.resultPointList = pointBuilder.build(opCode);
        this.resultGeom = this.computeGeometry(this.resultPointList, this.resultLineList, this.resultPolyList, opCode);
    }

    private void insertUniqueEdges(List edges) {
        for (Edge e2 : edges) {
            this.insertUniqueEdge(e2);
        }
    }

    protected void insertUniqueEdge(Edge e2) {
        Edge existingEdge = this.edgeList.findEqualEdge(e2);
        if (existingEdge != null) {
            Depth depth;
            Label existingLabel = existingEdge.getLabel();
            Label labelToMerge = e2.getLabel();
            if (!existingEdge.isPointwiseEqual(e2)) {
                labelToMerge = new Label(e2.getLabel());
                labelToMerge.flip();
            }
            if ((depth = existingEdge.getDepth()).isNull()) {
                depth.add(existingLabel);
            }
            depth.add(labelToMerge);
            existingLabel.merge(labelToMerge);
        } else {
            this.edgeList.add(e2);
        }
    }

    private void computeLabelsFromDepths() {
        Iterator it2 = this.edgeList.iterator();
        while (it2.hasNext()) {
            Edge e2 = (Edge)it2.next();
            Label lbl = e2.getLabel();
            Depth depth = e2.getDepth();
            if (depth.isNull()) continue;
            depth.normalize();
            for (int i2 = 0; i2 < 2; ++i2) {
                if (lbl.isNull(i2) || !lbl.isArea() || depth.isNull(i2)) continue;
                if (depth.getDelta(i2) == 0) {
                    lbl.toLine(i2);
                    continue;
                }
                Assert.isTrue(!depth.isNull(i2, 1), "depth of LEFT side has not been initialized");
                lbl.setLocation(i2, 1, depth.getLocation(i2, 1));
                Assert.isTrue(!depth.isNull(i2, 2), "depth of RIGHT side has not been initialized");
                lbl.setLocation(i2, 2, depth.getLocation(i2, 2));
            }
        }
    }

    private void replaceCollapsedEdges() {
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        Iterator it2 = this.edgeList.iterator();
        while (it2.hasNext()) {
            Edge e2 = (Edge)it2.next();
            if (!e2.isCollapsed()) continue;
            it2.remove();
            newEdges.add(e2.getCollapsedEdge());
        }
        this.edgeList.addAll(newEdges);
    }

    private void copyPoints(int argIndex) {
        Iterator i2 = this.arg[argIndex].getNodeIterator();
        while (i2.hasNext()) {
            Node graphNode = (Node)i2.next();
            Node newNode = this.graph.addNode(graphNode.getCoordinate());
            newNode.setLabel(argIndex, graphNode.getLabel().getLocation(argIndex));
        }
    }

    private void computeLabelling() {
        for (Node node : this.graph.getNodes()) {
            node.getEdges().computeLabelling(this.arg);
        }
        this.mergeSymLabels();
        this.updateNodeLabelling();
    }

    private void mergeSymLabels() {
        for (Node node : this.graph.getNodes()) {
            ((DirectedEdgeStar)node.getEdges()).mergeSymLabels();
        }
    }

    private void updateNodeLabelling() {
        for (Node node : this.graph.getNodes()) {
            Label lbl = ((DirectedEdgeStar)node.getEdges()).getLabel();
            node.getLabel().merge(lbl);
        }
    }

    private void labelIncompleteNodes() {
        int nodeCount = 0;
        for (Node n2 : this.graph.getNodes()) {
            Label label = n2.getLabel();
            if (n2.isIsolated()) {
                ++nodeCount;
                if (label.isNull(0)) {
                    this.labelIncompleteNode(n2, 0);
                } else {
                    this.labelIncompleteNode(n2, 1);
                }
            }
            ((DirectedEdgeStar)n2.getEdges()).updateLabelling(label);
        }
    }

    private void labelIncompleteNode(Node n2, int targetIndex) {
        int loc = this.ptLocator.locate(n2.getCoordinate(), this.arg[targetIndex].getGeometry());
        n2.getLabel().setLocation(targetIndex, loc);
    }

    private void findResultAreaEdges(int opCode) {
        for (DirectedEdge de2 : this.graph.getEdgeEnds()) {
            Label label = de2.getLabel();
            if (!label.isArea() || de2.isInteriorAreaEdge() || !OverlayOp.isResultOfOp(label.getLocation(0, 2), label.getLocation(1, 2), opCode)) continue;
            de2.setInResult(true);
        }
    }

    private void cancelDuplicateResultEdges() {
        for (DirectedEdge de2 : this.graph.getEdgeEnds()) {
            DirectedEdge sym = de2.getSym();
            if (!de2.isInResult() || !sym.isInResult()) continue;
            de2.setInResult(false);
            sym.setInResult(false);
        }
    }

    public boolean isCoveredByLA(Coordinate coord) {
        if (this.isCovered(coord, this.resultLineList)) {
            return true;
        }
        return this.isCovered(coord, this.resultPolyList);
    }

    public boolean isCoveredByA(Coordinate coord) {
        return this.isCovered(coord, this.resultPolyList);
    }

    private boolean isCovered(Coordinate coord, List geomList) {
        for (Geometry geom : geomList) {
            int loc = this.ptLocator.locate(coord, geom);
            if (loc == 2) continue;
            return true;
        }
        return false;
    }

    private Geometry computeGeometry(List resultPointList, List resultLineList, List resultPolyList, int opcode) {
        ArrayList geomList = new ArrayList();
        geomList.addAll(resultPointList);
        geomList.addAll(resultLineList);
        geomList.addAll(resultPolyList);
        if (geomList.isEmpty()) {
            return OverlayOp.createEmptyResult(opcode, this.arg[0].getGeometry(), this.arg[1].getGeometry(), this.geomFact);
        }
        return this.geomFact.buildGeometry(geomList);
    }

    public static Geometry createEmptyResult(int opCode, Geometry a2, Geometry b2, GeometryFactory geomFact) {
        Geometry result = null;
        switch (OverlayOp.resultDimension(opCode, a2, b2)) {
            case -1: {
                result = geomFact.createGeometryCollection(new Geometry[0]);
                break;
            }
            case 0: {
                result = geomFact.createPoint((Coordinate)null);
                break;
            }
            case 1: {
                result = geomFact.createLineString((Coordinate[])null);
                break;
            }
            case 2: {
                result = geomFact.createPolygon(null, null);
            }
        }
        return result;
    }

    private static int resultDimension(int opCode, Geometry g0, Geometry g1) {
        int dim0 = g0.getDimension();
        int dim1 = g1.getDimension();
        int resultDimension = -1;
        switch (opCode) {
            case 1: {
                resultDimension = Math.min(dim0, dim1);
                break;
            }
            case 2: {
                resultDimension = Math.max(dim0, dim1);
                break;
            }
            case 3: {
                resultDimension = dim0;
                break;
            }
            case 4: {
                resultDimension = Math.max(dim0, dim1);
            }
        }
        return resultDimension;
    }
}

