/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;

class OffsetSegmentString {
    private static final Coordinate[] COORDINATE_ARRAY_TYPE = new Coordinate[0];
    private ArrayList ptList = new ArrayList();
    private PrecisionModel precisionModel = null;
    private double minimimVertexDistance = 0.0;

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public void setMinimumVertexDistance(double minimimVertexDistance) {
        this.minimimVertexDistance = minimimVertexDistance;
    }

    public void addPt(Coordinate pt2) {
        Coordinate bufPt = new Coordinate(pt2);
        this.precisionModel.makePrecise(bufPt);
        if (this.isRedundant(bufPt)) {
            return;
        }
        this.ptList.add(bufPt);
    }

    public void addPts(Coordinate[] pt2, boolean isForward) {
        if (isForward) {
            for (int i2 = 0; i2 < pt2.length; ++i2) {
                this.addPt(pt2[i2]);
            }
        } else {
            for (int i3 = pt2.length - 1; i3 >= 0; --i3) {
                this.addPt(pt2[i3]);
            }
        }
    }

    private boolean isRedundant(Coordinate pt2) {
        if (this.ptList.size() < 1) {
            return false;
        }
        Coordinate lastPt = (Coordinate)this.ptList.get(this.ptList.size() - 1);
        double ptDist = pt2.distance(lastPt);
        return ptDist < this.minimimVertexDistance;
    }

    public void closeRing() {
        if (this.ptList.size() < 1) {
            return;
        }
        Coordinate startPt = new Coordinate((Coordinate)this.ptList.get(0));
        Coordinate lastPt = (Coordinate)this.ptList.get(this.ptList.size() - 1);
        Coordinate last2Pt = null;
        if (this.ptList.size() >= 2) {
            last2Pt = (Coordinate)this.ptList.get(this.ptList.size() - 2);
        }
        if (startPt.equals(lastPt)) {
            return;
        }
        this.ptList.add(startPt);
    }

    public void reverse() {
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coord = this.ptList.toArray(COORDINATE_ARRAY_TYPE);
        return coord;
    }

    public String toString() {
        GeometryFactory fact = new GeometryFactory();
        LineString line = fact.createLineString(this.getCoordinates());
        return line.toString();
    }
}

