/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class IsSimpleOp {
    private Geometry inputGeom;
    private boolean isClosedEndpointsInInterior = true;
    private Coordinate nonSimpleLocation = null;

    public IsSimpleOp() {
    }

    public IsSimpleOp(Geometry geom) {
        this.inputGeom = geom;
    }

    public IsSimpleOp(Geometry geom, BoundaryNodeRule boundaryNodeRule) {
        this.inputGeom = geom;
        this.isClosedEndpointsInInterior = !boundaryNodeRule.isInBoundary(2);
    }

    public boolean isSimple() {
        this.nonSimpleLocation = null;
        return this.computeSimple(this.inputGeom);
    }

    private boolean computeSimple(Geometry geom) {
        this.nonSimpleLocation = null;
        if (geom.isEmpty()) {
            return true;
        }
        if (geom instanceof LineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiLineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiPoint) {
            return this.isSimpleMultiPoint((MultiPoint)geom);
        }
        if (geom instanceof Polygonal) {
            return this.isSimplePolygonal(geom);
        }
        if (geom instanceof GeometryCollection) {
            return this.isSimpleGeometryCollection(geom);
        }
        return true;
    }

    public Coordinate getNonSimpleLocation() {
        return this.nonSimpleLocation;
    }

    public boolean isSimple(LineString geom) {
        return this.isSimpleLinearGeometry(geom);
    }

    public boolean isSimple(MultiLineString geom) {
        return this.isSimpleLinearGeometry(geom);
    }

    public boolean isSimple(MultiPoint mp2) {
        return this.isSimpleMultiPoint(mp2);
    }

    private boolean isSimpleMultiPoint(MultiPoint mp2) {
        if (mp2.isEmpty()) {
            return true;
        }
        TreeSet<Coordinate> points = new TreeSet<Coordinate>();
        for (int i2 = 0; i2 < mp2.getNumGeometries(); ++i2) {
            Point pt2 = (Point)mp2.getGeometryN(i2);
            Coordinate p2 = pt2.getCoordinate();
            if (points.contains(p2)) {
                this.nonSimpleLocation = p2;
                return false;
            }
            points.add(p2);
        }
        return true;
    }

    private boolean isSimplePolygonal(Geometry geom) {
        List rings = LinearComponentExtracter.getLines(geom);
        for (LinearRing ring : rings) {
            if (this.isSimpleLinearGeometry(ring)) continue;
            return false;
        }
        return true;
    }

    private boolean isSimpleGeometryCollection(Geometry geom) {
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Geometry comp = geom.getGeometryN(i2);
            if (this.computeSimple(comp)) continue;
            return false;
        }
        return true;
    }

    private boolean isSimpleLinearGeometry(Geometry geom) {
        if (geom.isEmpty()) {
            return true;
        }
        GeometryGraph graph = new GeometryGraph(0, geom);
        RobustLineIntersector li2 = new RobustLineIntersector();
        SegmentIntersector si = graph.computeSelfNodes(li2, true);
        if (!si.hasIntersection()) {
            return true;
        }
        if (si.hasProperIntersection()) {
            this.nonSimpleLocation = si.getProperIntersectionPoint();
            return false;
        }
        if (this.hasNonEndpointIntersection(graph)) {
            return false;
        }
        return !this.isClosedEndpointsInInterior || !this.hasClosedEndpointIntersection(graph);
    }

    private boolean hasNonEndpointIntersection(GeometryGraph graph) {
        Iterator i2 = graph.getEdgeIterator();
        while (i2.hasNext()) {
            Edge e2 = (Edge)i2.next();
            int maxSegmentIndex = e2.getMaximumSegmentIndex();
            Iterator eiIt = e2.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei2 = (EdgeIntersection)eiIt.next();
                if (ei2.isEndPoint(maxSegmentIndex)) continue;
                this.nonSimpleLocation = ei2.getCoordinate();
                return true;
            }
        }
        return false;
    }

    private boolean hasClosedEndpointIntersection(GeometryGraph graph) {
        TreeMap endPoints = new TreeMap();
        Iterator i2 = graph.getEdgeIterator();
        while (i2.hasNext()) {
            Edge e2 = (Edge)i2.next();
            int maxSegmentIndex = e2.getMaximumSegmentIndex();
            boolean isClosed = e2.isClosed();
            Coordinate p0 = e2.getCoordinate(0);
            this.addEndpoint(endPoints, p0, isClosed);
            Coordinate p1 = e2.getCoordinate(e2.getNumPoints() - 1);
            this.addEndpoint(endPoints, p1, isClosed);
        }
        for (EndpointInfo eiInfo : endPoints.values()) {
            if (!eiInfo.isClosed || eiInfo.degree == 2) continue;
            this.nonSimpleLocation = eiInfo.getCoordinate();
            return true;
        }
        return false;
    }

    private void addEndpoint(Map endPoints, Coordinate p2, boolean isClosed) {
        EndpointInfo eiInfo = (EndpointInfo)endPoints.get(p2);
        if (eiInfo == null) {
            eiInfo = new EndpointInfo(p2);
            endPoints.put(p2, eiInfo);
        }
        eiInfo.addEndpoint(isClosed);
    }

    private static class EndpointInfo {
        Coordinate pt;
        boolean isClosed;
        int degree;

        public EndpointInfo(Coordinate pt2) {
            this.pt = pt2;
            this.isClosed = false;
            this.degree = 0;
        }

        public Coordinate getCoordinate() {
            return this.pt;
        }

        public void addEndpoint(boolean isClosed) {
            ++this.degree;
            this.isClosed |= isClosed;
        }
    }
}

