/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.math;

import com.vividsolutions.jts.geom.Coordinate;

public class Vector3D {
    private double x;
    private double y;
    private double z;

    public static double dot(Coordinate A2, Coordinate B2, Coordinate C2, Coordinate D2) {
        double ABx = B2.x - A2.x;
        double ABy = B2.y - A2.y;
        double ABz = B2.z - A2.z;
        double CDx = D2.x - C2.x;
        double CDy = D2.y - C2.y;
        double CDz = D2.z - C2.z;
        return ABx * CDx + ABy * CDy + ABz * CDz;
    }

    public static Vector3D create(double x2, double y2, double z2) {
        return new Vector3D(x2, y2, z2);
    }

    public static Vector3D create(Coordinate coord) {
        return new Vector3D(coord);
    }

    public Vector3D(Coordinate v2) {
        this.x = v2.x;
        this.y = v2.y;
        this.z = v2.z;
    }

    public static double dot(Coordinate v1, Coordinate v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public Vector3D(Coordinate from, Coordinate to) {
        this.x = to.x - from.x;
        this.y = to.y - from.y;
        this.z = to.z - from.z;
    }

    public Vector3D(double x2, double y2, double z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double dot(Vector3D v2) {
        return this.x * v2.x + this.y * v2.y + this.z * v2.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static double length(Coordinate v2) {
        return Math.sqrt(v2.x * v2.x + v2.y * v2.y + v2.z * v2.z);
    }

    public Vector3D normalize() {
        double length = this.length();
        if (length > 0.0) {
            return this.divide(this.length());
        }
        return Vector3D.create(0.0, 0.0, 0.0);
    }

    private Vector3D divide(double d2) {
        return Vector3D.create(this.x / d2, this.y / d2, this.z / d2);
    }

    public static Coordinate normalize(Coordinate v2) {
        double len = Vector3D.length(v2);
        return new Coordinate(v2.x / len, v2.y / len, v2.z / len);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

