/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.linearref.LinearGeometryBuilder;
import com.vividsolutions.jts.linearref.LinearIterator;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.util.Assert;

class ExtractLineByLocation {
    private Geometry line;

    public static Geometry extract(Geometry line, LinearLocation start, LinearLocation end) {
        ExtractLineByLocation ls2 = new ExtractLineByLocation(line);
        return ls2.extract(start, end);
    }

    public ExtractLineByLocation(Geometry line) {
        this.line = line;
    }

    public Geometry extract(LinearLocation start, LinearLocation end) {
        if (end.compareTo(start) < 0) {
            return this.reverse(this.computeLinear(end, start));
        }
        return this.computeLinear(start, end);
    }

    private Geometry reverse(Geometry linear) {
        if (linear instanceof LineString) {
            return ((LineString)linear).reverse();
        }
        if (linear instanceof MultiLineString) {
            return ((MultiLineString)linear).reverse();
        }
        Assert.shouldNeverReachHere("non-linear geometry encountered");
        return null;
    }

    private LineString computeLine(LinearLocation start, LinearLocation end) {
        Coordinate[] newCoordinateArray;
        Coordinate[] coordinates = this.line.getCoordinates();
        CoordinateList newCoordinates = new CoordinateList();
        int startSegmentIndex = start.getSegmentIndex();
        if (start.getSegmentFraction() > 0.0) {
            ++startSegmentIndex;
        }
        int lastSegmentIndex = end.getSegmentIndex();
        if (end.getSegmentFraction() == 1.0) {
            ++lastSegmentIndex;
        }
        if (lastSegmentIndex >= coordinates.length) {
            lastSegmentIndex = coordinates.length - 1;
        }
        if (!start.isVertex()) {
            newCoordinates.add(start.getCoordinate(this.line));
        }
        for (int i2 = startSegmentIndex; i2 <= lastSegmentIndex; ++i2) {
            newCoordinates.add(coordinates[i2]);
        }
        if (!end.isVertex()) {
            newCoordinates.add(end.getCoordinate(this.line));
        }
        if (newCoordinates.size() <= 0) {
            newCoordinates.add(start.getCoordinate(this.line));
        }
        if ((newCoordinateArray = newCoordinates.toCoordinateArray()).length <= 1) {
            newCoordinateArray = new Coordinate[]{newCoordinateArray[0], newCoordinateArray[0]};
        }
        return this.line.getFactory().createLineString(newCoordinateArray);
    }

    private Geometry computeLinear(LinearLocation start, LinearLocation end) {
        LinearGeometryBuilder builder = new LinearGeometryBuilder(this.line.getFactory());
        builder.setFixInvalidLines(true);
        if (!start.isVertex()) {
            builder.add(start.getCoordinate(this.line));
        }
        LinearIterator it2 = new LinearIterator(this.line, start);
        while (it2.hasNext() && end.compareLocationValues(it2.getComponentIndex(), it2.getVertexIndex(), 0.0) >= 0) {
            Coordinate pt2 = it2.getSegmentStart();
            builder.add(pt2);
            if (it2.isEndOfLine()) {
                builder.endLine();
            }
            it2.next();
        }
        if (!end.isVertex()) {
            builder.add(end.getCoordinate(this.line));
        }
        return builder.getGeometry();
    }
}

