/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io.gml2;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.gml2.GMLHandler;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GeometryStrategies {
    private static HashMap strategies = GeometryStrategies.loadStrategies();

    private static HashMap loadStrategies() {
        HashMap<String, ParseStrategy> strats = new HashMap<String, ParseStrategy>();
        strats.put("Point".toLowerCase(), new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.children.size() != 1) {
                    throw new SAXException("Cannot create a point without exactly one coordinate");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf2.getSRID());
                Object c2 = arg.children.get(0);
                Point p2 = null;
                p2 = c2 instanceof Coordinate ? gf2.createPoint((Coordinate)c2) : gf2.createPoint((CoordinateSequence)c2);
                if (p2.getSRID() != srid) {
                    p2.setSRID(srid);
                }
                return p2;
            }
        });
        strats.put("LineString".toLowerCase(), new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a linestring without atleast two coordinates or one coordinate sequence");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf2.getSRID());
                LineString ls2 = null;
                if (arg.children.size() == 1) {
                    try {
                        CoordinateSequence cs2 = (CoordinateSequence)arg.children.get(0);
                        ls2 = gf2.createLineString(cs2);
                    }
                    catch (ClassCastException e2) {
                        throw new SAXException("Cannot create a linestring without atleast two coordinates or one coordinate sequence", e2);
                    }
                }
                try {
                    Coordinate[] coords = arg.children.toArray(new Coordinate[arg.children.size()]);
                    ls2 = gf2.createLineString(coords);
                }
                catch (ClassCastException e3) {
                    throw new SAXException("Cannot create a linestring without atleast two coordinates or one coordinate sequence", e3);
                }
                if (ls2.getSRID() != srid) {
                    ls2.setSRID(srid);
                }
                return ls2;
            }
        });
        strats.put("LinearRing".toLowerCase(), new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.children.size() != 1 && arg.children.size() < 4) {
                    throw new SAXException("Cannot create a linear ring without atleast four coordinates or one coordinate sequence");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf2.getSRID());
                LinearRing ls2 = null;
                if (arg.children.size() == 1) {
                    try {
                        CoordinateSequence cs2 = (CoordinateSequence)arg.children.get(0);
                        ls2 = gf2.createLinearRing(cs2);
                    }
                    catch (ClassCastException e2) {
                        throw new SAXException("Cannot create a linear ring without atleast four coordinates or one coordinate sequence", e2);
                    }
                }
                try {
                    Coordinate[] coords = arg.children.toArray(new Coordinate[arg.children.size()]);
                    ls2 = gf2.createLinearRing(coords);
                }
                catch (ClassCastException e3) {
                    throw new SAXException("Cannot create a linear ring without atleast four coordinates or one coordinate sequence", e3);
                }
                if (ls2.getSRID() != srid) {
                    ls2.setSRID(srid);
                }
                return ls2;
            }
        });
        strats.put("Polygon".toLowerCase(), new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                List t2;
                LinearRing[] inner;
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a polygon without atleast one linear ring");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf2.getSRID());
                LinearRing outer = (LinearRing)arg.children.get(0);
                Polygon p2 = gf2.createPolygon(outer, inner = (t2 = arg.children.size() > 1 ? arg.children.subList(1, arg.children.size()) : null) == null ? null : t2.toArray(new LinearRing[t2.size()]));
                if (p2.getSRID() != srid) {
                    p2.setSRID(srid);
                }
                return p2;
            }
        });
        strats.put("Box".toLowerCase(), new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.children.size() < 1 || arg.children.size() > 2) {
                    throw new SAXException("Cannot create a box without either two coords or one coordinate sequence");
                }
                Envelope box = null;
                if (arg.children.size() == 1) {
                    CoordinateSequence cs2 = (CoordinateSequence)arg.children.get(0);
                    box = cs2.expandEnvelope(new Envelope());
                } else {
                    box = new Envelope((Coordinate)arg.children.get(0), (Coordinate)arg.children.get(1));
                }
                return box;
            }
        });
        strats.put("MultiPoint".toLowerCase(), new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a multi-point without atleast one point");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf2.getSRID());
                Point[] pts = arg.children.toArray(new Point[arg.children.size()]);
                MultiPoint mp2 = gf2.createMultiPoint(pts);
                if (mp2.getSRID() != srid) {
                    mp2.setSRID(srid);
                }
                return mp2;
            }
        });
        strats.put("MultiLineString".toLowerCase(), new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a multi-linestring without atleast one linestring");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf2.getSRID());
                LineString[] lns = arg.children.toArray(new LineString[arg.children.size()]);
                MultiLineString mp2 = gf2.createMultiLineString(lns);
                if (mp2.getSRID() != srid) {
                    mp2.setSRID(srid);
                }
                return mp2;
            }
        });
        strats.put("MultiPolygon".toLowerCase(), new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a multi-polygon without atleast one polygon");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf2.getSRID());
                Polygon[] plys = arg.children.toArray(new Polygon[arg.children.size()]);
                MultiPolygon mp2 = gf2.createMultiPolygon(plys);
                if (mp2.getSRID() != srid) {
                    mp2.setSRID(srid);
                }
                return mp2;
            }
        });
        strats.put("MultiGeometry".toLowerCase(), new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a multi-polygon without atleast one geometry");
                }
                Geometry[] geoms = arg.children.toArray(new Geometry[arg.children.size()]);
                GeometryCollection gc2 = gf2.createGeometryCollection(geoms);
                return gc2;
            }
        });
        strats.put("coordinates".toLowerCase(), new ParseStrategy(){
            private WeakHashMap patterns = new WeakHashMap();

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                int i2;
                String[] touples;
                if (arg.text == null || "".equals(arg.text)) {
                    throw new SAXException("Cannot create a coordinate sequence without text to parse");
                }
                String decimal = ".";
                String coordSeperator = ",";
                String toupleSeperator = " ";
                if (arg.attrs.getIndex("decimal") >= 0) {
                    decimal = arg.attrs.getValue("decimal");
                } else if (arg.attrs.getIndex("http://www.opengis.net/gml", "decimal") >= 0) {
                    decimal = arg.attrs.getValue("http://www.opengis.net/gml", "decimal");
                }
                if (arg.attrs.getIndex("cs") >= 0) {
                    coordSeperator = arg.attrs.getValue("cs");
                } else if (arg.attrs.getIndex("http://www.opengis.net/gml", "cs") >= 0) {
                    coordSeperator = arg.attrs.getValue("http://www.opengis.net/gml", "cs");
                }
                if (arg.attrs.getIndex("ts") >= 0) {
                    toupleSeperator = arg.attrs.getValue("ts");
                } else if (arg.attrs.getIndex("http://www.opengis.net/gml", "ts") >= 0) {
                    toupleSeperator = arg.attrs.getValue("http://www.opengis.net/gml", "ts");
                }
                String t2 = arg.text.toString();
                t2 = t2.replaceAll("\\s", " ");
                Pattern ptn = (Pattern)this.patterns.get(toupleSeperator);
                if (ptn == null) {
                    String ts = new String(toupleSeperator);
                    if (ts.indexOf(92) > -1) {
                        ts = ts.replaceAll("\\", "\\\\");
                    }
                    if (ts.indexOf(46) > -1) {
                        ts = ts.replaceAll("\\.", "\\\\.");
                    }
                    ptn = Pattern.compile(ts);
                    this.patterns.put(toupleSeperator, ptn);
                }
                if ((touples = ptn.split(t2.trim())).length == 0) {
                    throw new SAXException("Cannot create a coordinate sequence without a touple to parse");
                }
                int numNonNullTouples = 0;
                for (i2 = 0; i2 < touples.length; ++i2) {
                    if (touples[i2] == null || "".equals(touples[i2].trim())) continue;
                    if (i2 != numNonNullTouples) {
                        touples[numNonNullTouples] = touples[i2];
                    }
                    ++numNonNullTouples;
                }
                for (i2 = numNonNullTouples; i2 < touples.length; ++i2) {
                    touples[i2] = null;
                }
                if (numNonNullTouples == 0) {
                    throw new SAXException("Cannot create a coordinate sequence without a non-null touple to parse");
                }
                int dim = touples[0].split(coordSeperator).length;
                CoordinateSequence cs2 = gf2.getCoordinateSequenceFactory().create(numNonNullTouples, dim);
                dim = cs2.getDimension();
                boolean replaceDec = !".".equals(decimal);
                for (int i3 = 0; i3 < numNonNullTouples; ++i3) {
                    ptn = (Pattern)this.patterns.get(coordSeperator);
                    if (ptn == null) {
                        String ts = new String(coordSeperator);
                        if (ts.indexOf(92) > -1) {
                            ts = ts.replaceAll("\\", "\\\\");
                        }
                        if (ts.indexOf(46) > -1) {
                            ts = ts.replaceAll("\\.", "\\\\.");
                        }
                        ptn = Pattern.compile(ts);
                        this.patterns.put(coordSeperator, ptn);
                    }
                    String[] coords = ptn.split(touples[i3]);
                    int dimIndex = 0;
                    for (int j2 = 0; j2 < coords.length && j2 < dim; ++j2) {
                        if (coords[j2] == null || "".equals(coords[j2].trim())) continue;
                        double ordinate = Double.parseDouble(replaceDec ? coords[j2].replaceAll(decimal, ".") : coords[j2]);
                        cs2.setOrdinate(i3, dimIndex++, ordinate);
                    }
                    while (dimIndex < dim) {
                        cs2.setOrdinate(i3, dimIndex++, Double.NaN);
                    }
                }
                return cs2;
            }
        });
        strats.put("coord".toLowerCase(), new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a coordinate without atleast one axis");
                }
                if (arg.children.size() > 3) {
                    throw new SAXException("Cannot create a coordinate with more than 3 axis");
                }
                Double[] axis = arg.children.toArray(new Double[arg.children.size()]);
                Coordinate c2 = new Coordinate();
                c2.x = axis[0];
                if (axis.length > 1) {
                    c2.y = axis[1];
                }
                if (axis.length > 2) {
                    c2.z = axis[2];
                }
                return c2;
            }
        });
        ParseStrategy coord_child = new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.text == null) {
                    return null;
                }
                return new Double(arg.text.toString());
            }
        };
        strats.put("X".toLowerCase(), coord_child);
        strats.put("Y".toLowerCase(), coord_child);
        strats.put("Z".toLowerCase(), coord_child);
        ParseStrategy member = new ParseStrategy(){

            public Object parse(GMLHandler.Handler arg, GeometryFactory gf2) throws SAXException {
                if (arg.children.size() != 1) {
                    throw new SAXException("Geometry Members may only contain one geometry.");
                }
                return arg.children.get(0);
            }
        };
        strats.put("outerBoundaryIs".toLowerCase(), member);
        strats.put("innerBoundaryIs".toLowerCase(), member);
        strats.put("pointMember".toLowerCase(), member);
        strats.put("lineStringMember".toLowerCase(), member);
        strats.put("polygonMember".toLowerCase(), member);
        return strats;
    }

    static int getSrid(Attributes attrs, int defaultValue) {
        String srs = null;
        if (attrs.getIndex("srsName") >= 0) {
            srs = attrs.getValue("srsName");
        } else if (attrs.getIndex("http://www.opengis.net/gml", "srsName") >= 0) {
            srs = attrs.getValue("http://www.opengis.net/gml", "srsName");
        }
        if (srs != null && (srs = srs.trim()) != null && !"".equals(srs)) {
            try {
                return Integer.parseInt(srs);
            }
            catch (NumberFormatException e2) {
                int index = srs.lastIndexOf(35);
                if (index > -1) {
                    srs = srs.substring(index);
                }
                try {
                    return Integer.parseInt(srs);
                }
                catch (NumberFormatException e22) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    public static ParseStrategy findStrategy(String uri, String localName) {
        return localName == null ? null : (ParseStrategy)strategies.get(localName.toLowerCase());
    }

    static interface ParseStrategy {
        public Object parse(GMLHandler.Handler var1, GeometryFactory var2) throws SAXException;
    }
}

