/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;

public class WKTReader {
    private static final String EMPTY = "EMPTY";
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private static final String NAN_SYMBOL = "NaN";
    private GeometryFactory geometryFactory;
    private PrecisionModel precisionModel;
    private StreamTokenizer tokenizer;
    private static final boolean ALLOW_OLD_JTS_MULTIPOINT_SYNTAX = true;

    public WKTReader() {
        this(new GeometryFactory());
    }

    public WKTReader(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.precisionModel = geometryFactory.getPrecisionModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry read(String wellKnownText) throws ParseException {
        StringReader reader = new StringReader(wellKnownText);
        try {
            Geometry geometry = this.read(reader);
            return geometry;
        }
        finally {
            reader.close();
        }
    }

    public Geometry read(Reader reader) throws ParseException {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(160, 255);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(45, 45);
        this.tokenizer.wordChars(43, 43);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        try {
            return this.readGeometryTaggedText();
        }
        catch (IOException e2) {
            throw new ParseException(e2.toString());
        }
    }

    private Coordinate[] getCoordinates() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return new Coordinate[0];
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(this.getPreciseCoordinate());
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            coordinates.add(this.getPreciseCoordinate());
            nextToken = this.getNextCloserOrComma();
        }
        Coordinate[] array = new Coordinate[coordinates.size()];
        return coordinates.toArray(array);
    }

    private Coordinate[] getCoordinatesNoLeftParen() throws IOException, ParseException {
        String nextToken = null;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(this.getPreciseCoordinate());
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            coordinates.add(this.getPreciseCoordinate());
            nextToken = this.getNextCloserOrComma();
        }
        Coordinate[] array = new Coordinate[coordinates.size()];
        return coordinates.toArray(array);
    }

    private Coordinate getPreciseCoordinate() throws IOException, ParseException {
        Coordinate coord = new Coordinate();
        coord.x = this.getNextNumber();
        coord.y = this.getNextNumber();
        if (this.isNumberNext()) {
            coord.z = this.getNextNumber();
        }
        this.precisionModel.makePrecise(coord);
        return coord;
    }

    private boolean isNumberNext() throws IOException {
        int type = this.tokenizer.nextToken();
        this.tokenizer.pushBack();
        return type == -3;
    }

    private double getNextNumber() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                if (this.tokenizer.sval.equalsIgnoreCase(NAN_SYMBOL)) {
                    return Double.NaN;
                }
                try {
                    return Double.parseDouble(this.tokenizer.sval);
                }
                catch (NumberFormatException ex2) {
                    this.parseErrorWithLine("Invalid number: " + this.tokenizer.sval);
                }
            }
        }
        this.parseErrorExpected("number");
        return 0.0;
    }

    private String getNextEmptyOrOpener() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(EMPTY) || nextWord.equals(L_PAREN)) {
            return nextWord;
        }
        this.parseErrorExpected("EMPTY or (");
        return null;
    }

    private String getNextCloserOrComma() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(COMMA) || nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseErrorExpected(", or )");
        return null;
    }

    private String getNextCloser() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseErrorExpected(R_PAREN);
        return null;
    }

    private String getNextWord() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                String word = this.tokenizer.sval;
                if (word.equalsIgnoreCase(EMPTY)) {
                    return EMPTY;
                }
                return word;
            }
            case 40: {
                return L_PAREN;
            }
            case 41: {
                return R_PAREN;
            }
            case 44: {
                return COMMA;
            }
        }
        this.parseErrorExpected("word");
        return null;
    }

    private String lookaheadWord() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        this.tokenizer.pushBack();
        return nextWord;
    }

    private void parseErrorExpected(String expected) throws ParseException {
        if (this.tokenizer.ttype == -2) {
            Assert.shouldNeverReachHere("Unexpected NUMBER token");
        }
        if (this.tokenizer.ttype == 10) {
            Assert.shouldNeverReachHere("Unexpected EOL token");
        }
        String tokenStr = this.tokenString();
        this.parseErrorWithLine("Expected " + expected + " but found " + tokenStr);
    }

    private void parseErrorWithLine(String msg) throws ParseException {
        throw new ParseException(msg + " (line " + this.tokenizer.lineno() + R_PAREN);
    }

    private String tokenString() {
        switch (this.tokenizer.ttype) {
            case -2: {
                return "<NUMBER>";
            }
            case 10: {
                return "End-of-Line";
            }
            case -1: {
                return "End-of-Stream";
            }
            case -3: {
                return "'" + this.tokenizer.sval + "'";
            }
        }
        return "'" + (char)this.tokenizer.ttype + "'";
    }

    private Geometry readGeometryTaggedText() throws IOException, ParseException {
        String type = null;
        try {
            type = this.getNextWord();
        }
        catch (IOException e2) {
            return null;
        }
        catch (ParseException e3) {
            return null;
        }
        if (type.equalsIgnoreCase("POINT")) {
            return this.readPointText();
        }
        if (type.equalsIgnoreCase("LINESTRING")) {
            return this.readLineStringText();
        }
        if (type.equalsIgnoreCase("LINEARRING")) {
            return this.readLinearRingText();
        }
        if (type.equalsIgnoreCase("POLYGON")) {
            return this.readPolygonText();
        }
        if (type.equalsIgnoreCase("MULTIPOINT")) {
            return this.readMultiPointText();
        }
        if (type.equalsIgnoreCase("MULTILINESTRING")) {
            return this.readMultiLineStringText();
        }
        if (type.equalsIgnoreCase("MULTIPOLYGON")) {
            return this.readMultiPolygonText();
        }
        if (type.equalsIgnoreCase("GEOMETRYCOLLECTION")) {
            return this.readGeometryCollectionText();
        }
        this.parseErrorWithLine("Unknown geometry type: " + type);
        return null;
    }

    private Point readPointText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createPoint((Coordinate)null);
        }
        Point point = this.geometryFactory.createPoint(this.getPreciseCoordinate());
        this.getNextCloser();
        return point;
    }

    private LineString readLineStringText() throws IOException, ParseException {
        return this.geometryFactory.createLineString(this.getCoordinates());
    }

    private LinearRing readLinearRingText() throws IOException, ParseException {
        return this.geometryFactory.createLinearRing(this.getCoordinates());
    }

    private MultiPoint readMultiPointText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createMultiPoint(new Point[0]);
        }
        String nextWord = this.lookaheadWord();
        if (nextWord != L_PAREN) {
            return this.geometryFactory.createMultiPoint(this.toPoints(this.getCoordinatesNoLeftParen()));
        }
        ArrayList<Point> points = new ArrayList<Point>();
        Point point = this.readPointText();
        points.add(point);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            point = this.readPointText();
            points.add(point);
            nextToken = this.getNextCloserOrComma();
        }
        Point[] array = new Point[points.size()];
        return this.geometryFactory.createMultiPoint(points.toArray(array));
    }

    private Point[] toPoints(Coordinate[] coordinates) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i2 = 0; i2 < coordinates.length; ++i2) {
            points.add(this.geometryFactory.createPoint(coordinates[i2]));
        }
        return points.toArray(new Point[0]);
    }

    private Polygon readPolygonText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]);
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        LinearRing shell = this.readLinearRingText();
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            LinearRing hole = this.readLinearRingText();
            holes.add(hole);
            nextToken = this.getNextCloserOrComma();
        }
        LinearRing[] array = new LinearRing[holes.size()];
        return this.geometryFactory.createPolygon(shell, holes.toArray(array));
    }

    private MultiLineString readMultiLineStringText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createMultiLineString(new LineString[0]);
        }
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        LineString lineString = this.readLineStringText();
        lineStrings.add(lineString);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            lineString = this.readLineStringText();
            lineStrings.add(lineString);
            nextToken = this.getNextCloserOrComma();
        }
        LineString[] array = new LineString[lineStrings.size()];
        return this.geometryFactory.createMultiLineString(lineStrings.toArray(array));
    }

    private MultiPolygon readMultiPolygonText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createMultiPolygon(new Polygon[0]);
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        Polygon polygon = this.readPolygonText();
        polygons.add(polygon);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            polygon = this.readPolygonText();
            polygons.add(polygon);
            nextToken = this.getNextCloserOrComma();
        }
        Polygon[] array = new Polygon[polygons.size()];
        return this.geometryFactory.createMultiPolygon(polygons.toArray(array));
    }

    private GeometryCollection readGeometryCollectionText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createGeometryCollection(new Geometry[0]);
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        Geometry geometry = this.readGeometryTaggedText();
        geometries.add(geometry);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            geometry = this.readGeometryTaggedText();
            geometries.add(geometry);
            nextToken = this.getNextCloserOrComma();
        }
        Geometry[] array = new Geometry[geometries.size()];
        return this.geometryFactory.createGeometryCollection(geometries.toArray(array));
    }
}

