/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.sweepline;

import com.vividsolutions.jts.index.sweepline.SweepLineEvent;
import com.vividsolutions.jts.index.sweepline.SweepLineInterval;
import com.vividsolutions.jts.index.sweepline.SweepLineOverlapAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SweepLineIndex {
    List events = new ArrayList();
    private boolean indexBuilt;
    private int nOverlaps;

    public void add(SweepLineInterval sweepInt) {
        SweepLineEvent insertEvent = new SweepLineEvent(sweepInt.getMin(), null, sweepInt);
        this.events.add(insertEvent);
        this.events.add(new SweepLineEvent(sweepInt.getMax(), insertEvent, sweepInt));
    }

    private void buildIndex() {
        if (this.indexBuilt) {
            return;
        }
        Collections.sort(this.events);
        for (int i2 = 0; i2 < this.events.size(); ++i2) {
            SweepLineEvent ev2 = (SweepLineEvent)this.events.get(i2);
            if (!ev2.isDelete()) continue;
            ev2.getInsertEvent().setDeleteEventIndex(i2);
        }
        this.indexBuilt = true;
    }

    public void computeOverlaps(SweepLineOverlapAction action) {
        this.nOverlaps = 0;
        this.buildIndex();
        for (int i2 = 0; i2 < this.events.size(); ++i2) {
            SweepLineEvent ev2 = (SweepLineEvent)this.events.get(i2);
            if (!ev2.isInsert()) continue;
            this.processOverlaps(i2, ev2.getDeleteEventIndex(), ev2.getInterval(), action);
        }
    }

    private void processOverlaps(int start, int end, SweepLineInterval s0, SweepLineOverlapAction action) {
        for (int i2 = start; i2 < end; ++i2) {
            SweepLineEvent ev2 = (SweepLineEvent)this.events.get(i2);
            if (!ev2.isInsert()) continue;
            SweepLineInterval s1 = ev2.getInterval();
            action.overlap(s0, s1);
            ++this.nOverlaps;
        }
    }
}

