/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractSTRtree
implements Serializable {
    private static final long serialVersionUID = -3886435814360241337L;
    protected AbstractNode root;
    private boolean built = false;
    private ArrayList itemBoundables = new ArrayList();
    private int nodeCapacity;
    private static final int DEFAULT_NODE_CAPACITY = 10;

    public AbstractSTRtree() {
        this(10);
    }

    public AbstractSTRtree(int nodeCapacity) {
        Assert.isTrue(nodeCapacity > 1, "Node capacity must be greater than 1");
        this.nodeCapacity = nodeCapacity;
    }

    public void build() {
        if (this.built) {
            return;
        }
        this.root = this.itemBoundables.isEmpty() ? this.createNode(0) : this.createHigherLevels(this.itemBoundables, -1);
        this.itemBoundables = null;
        this.built = true;
    }

    protected abstract AbstractNode createNode(int var1);

    protected List createParentBoundables(List childBoundables, int newLevel) {
        Assert.isTrue(!childBoundables.isEmpty());
        ArrayList<AbstractNode> parentBoundables = new ArrayList<AbstractNode>();
        parentBoundables.add(this.createNode(newLevel));
        ArrayList sortedChildBoundables = new ArrayList(childBoundables);
        Collections.sort(sortedChildBoundables, this.getComparator());
        for (Boundable childBoundable : sortedChildBoundables) {
            if (this.lastNode(parentBoundables).getChildBoundables().size() == this.getNodeCapacity()) {
                parentBoundables.add(this.createNode(newLevel));
            }
            this.lastNode(parentBoundables).addChildBoundable(childBoundable);
        }
        return parentBoundables;
    }

    protected AbstractNode lastNode(List nodes) {
        return (AbstractNode)nodes.get(nodes.size() - 1);
    }

    protected static int compareDoubles(double a2, double b2) {
        return a2 > b2 ? 1 : (a2 < b2 ? -1 : 0);
    }

    private AbstractNode createHigherLevels(List boundablesOfALevel, int level) {
        Assert.isTrue(!boundablesOfALevel.isEmpty());
        List parentBoundables = this.createParentBoundables(boundablesOfALevel, level + 1);
        if (parentBoundables.size() == 1) {
            return (AbstractNode)parentBoundables.get(0);
        }
        return this.createHigherLevels(parentBoundables, level + 1);
    }

    public AbstractNode getRoot() {
        this.build();
        return this.root;
    }

    public int getNodeCapacity() {
        return this.nodeCapacity;
    }

    public boolean isEmpty() {
        if (!this.built) {
            return this.itemBoundables.isEmpty();
        }
        return this.root.isEmpty();
    }

    protected int size() {
        if (this.isEmpty()) {
            return 0;
        }
        this.build();
        return this.size(this.root);
    }

    protected int size(AbstractNode node) {
        int size = 0;
        for (Boundable childBoundable : node.getChildBoundables()) {
            if (childBoundable instanceof AbstractNode) {
                size += this.size((AbstractNode)childBoundable);
                continue;
            }
            if (!(childBoundable instanceof ItemBoundable)) continue;
            ++size;
        }
        return size;
    }

    protected int depth() {
        if (this.isEmpty()) {
            return 0;
        }
        this.build();
        return this.depth(this.root);
    }

    protected int depth(AbstractNode node) {
        int maxChildDepth = 0;
        for (Boundable childBoundable : node.getChildBoundables()) {
            int childDepth;
            if (!(childBoundable instanceof AbstractNode) || (childDepth = this.depth((AbstractNode)childBoundable)) <= maxChildDepth) continue;
            maxChildDepth = childDepth;
        }
        return maxChildDepth + 1;
    }

    protected void insert(Object bounds, Object item) {
        Assert.isTrue(!this.built, "Cannot insert items into an STR packed R-tree after it has been built.");
        this.itemBoundables.add(new ItemBoundable(bounds, item));
    }

    protected List query(Object searchBounds) {
        this.build();
        ArrayList matches = new ArrayList();
        if (this.isEmpty()) {
            return matches;
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), searchBounds)) {
            this.query(searchBounds, this.root, matches);
        }
        return matches;
    }

    protected void query(Object searchBounds, ItemVisitor visitor) {
        this.build();
        if (this.isEmpty()) {
            return;
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), searchBounds)) {
            this.query(searchBounds, this.root, visitor);
        }
    }

    protected abstract IntersectsOp getIntersectsOp();

    private void query(Object searchBounds, AbstractNode node, List matches) {
        List childBoundables = node.getChildBoundables();
        for (int i2 = 0; i2 < childBoundables.size(); ++i2) {
            Boundable childBoundable = (Boundable)childBoundables.get(i2);
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds)) continue;
            if (childBoundable instanceof AbstractNode) {
                this.query(searchBounds, (AbstractNode)childBoundable, matches);
                continue;
            }
            if (childBoundable instanceof ItemBoundable) {
                matches.add(((ItemBoundable)childBoundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere();
        }
    }

    private void query(Object searchBounds, AbstractNode node, ItemVisitor visitor) {
        List childBoundables = node.getChildBoundables();
        for (int i2 = 0; i2 < childBoundables.size(); ++i2) {
            Boundable childBoundable = (Boundable)childBoundables.get(i2);
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds)) continue;
            if (childBoundable instanceof AbstractNode) {
                this.query(searchBounds, (AbstractNode)childBoundable, visitor);
                continue;
            }
            if (childBoundable instanceof ItemBoundable) {
                visitor.visitItem(((ItemBoundable)childBoundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere();
        }
    }

    public List itemsTree() {
        this.build();
        List valuesTree = this.itemsTree(this.root);
        if (valuesTree == null) {
            return new ArrayList();
        }
        return valuesTree;
    }

    private List itemsTree(AbstractNode node) {
        ArrayList<Object> valuesTreeForNode = new ArrayList<Object>();
        for (Boundable childBoundable : node.getChildBoundables()) {
            if (childBoundable instanceof AbstractNode) {
                List valuesTreeForChild = this.itemsTree((AbstractNode)childBoundable);
                if (valuesTreeForChild == null) continue;
                valuesTreeForNode.add(valuesTreeForChild);
                continue;
            }
            if (childBoundable instanceof ItemBoundable) {
                valuesTreeForNode.add(((ItemBoundable)childBoundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere();
        }
        if (valuesTreeForNode.size() <= 0) {
            return null;
        }
        return valuesTreeForNode;
    }

    protected boolean remove(Object searchBounds, Object item) {
        this.build();
        if (this.itemBoundables.isEmpty()) {
            Assert.isTrue(this.root.getBounds() == null);
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), searchBounds)) {
            return this.remove(searchBounds, this.root, item);
        }
        return false;
    }

    private boolean removeItem(AbstractNode node, Object item) {
        Boundable childToRemove = null;
        for (Boundable childBoundable : node.getChildBoundables()) {
            if (!(childBoundable instanceof ItemBoundable) || ((ItemBoundable)childBoundable).getItem() != item) continue;
            childToRemove = childBoundable;
        }
        if (childToRemove != null) {
            node.getChildBoundables().remove(childToRemove);
            return true;
        }
        return false;
    }

    private boolean remove(Object searchBounds, AbstractNode node, Object item) {
        boolean found = this.removeItem(node, item);
        if (found) {
            return true;
        }
        AbstractNode childToPrune = null;
        for (Boundable childBoundable : node.getChildBoundables()) {
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds) || !(childBoundable instanceof AbstractNode) || !(found = this.remove(searchBounds, (AbstractNode)childBoundable, item))) continue;
            childToPrune = (AbstractNode)childBoundable;
            break;
        }
        if (childToPrune != null && childToPrune.getChildBoundables().isEmpty()) {
            node.getChildBoundables().remove(childToPrune);
        }
        return found;
    }

    protected List boundablesAtLevel(int level) {
        ArrayList boundables = new ArrayList();
        this.boundablesAtLevel(level, this.root, boundables);
        return boundables;
    }

    private void boundablesAtLevel(int level, AbstractNode top, Collection boundables) {
        Assert.isTrue(level > -2);
        if (top.getLevel() == level) {
            boundables.add(top);
            return;
        }
        for (Boundable boundable : top.getChildBoundables()) {
            if (boundable instanceof AbstractNode) {
                this.boundablesAtLevel(level, (AbstractNode)boundable, boundables);
                continue;
            }
            Assert.isTrue(boundable instanceof ItemBoundable);
            if (level != -1) continue;
            boundables.add(boundable);
        }
    }

    protected abstract Comparator getComparator();

    protected static interface IntersectsOp {
        public boolean intersects(Object var1, Object var2);
    }
}

