/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Node;
import java.util.Collection;

public class SegmentIntersector {
    private boolean hasIntersection = false;
    private boolean hasProper = false;
    private boolean hasProperInterior = false;
    private Coordinate properIntersectionPoint = null;
    private LineIntersector li;
    private boolean includeProper;
    private boolean recordIsolated;
    private boolean isSelfIntersection;
    private int numIntersections = 0;
    public int numTests = 0;
    private Collection[] bdyNodes;

    public static boolean isAdjacentSegments(int i1, int i2) {
        return Math.abs(i1 - i2) == 1;
    }

    public SegmentIntersector(LineIntersector li2, boolean includeProper, boolean recordIsolated) {
        this.li = li2;
        this.includeProper = includeProper;
        this.recordIsolated = recordIsolated;
    }

    public void setBoundaryNodes(Collection bdyNodes0, Collection bdyNodes1) {
        this.bdyNodes = new Collection[2];
        this.bdyNodes[0] = bdyNodes0;
        this.bdyNodes[1] = bdyNodes1;
    }

    public Coordinate getProperIntersectionPoint() {
        return this.properIntersectionPoint;
    }

    public boolean hasIntersection() {
        return this.hasIntersection;
    }

    public boolean hasProperIntersection() {
        return this.hasProper;
    }

    public boolean hasProperInteriorIntersection() {
        return this.hasProperInterior;
    }

    private boolean isTrivialIntersection(Edge e0, int segIndex0, Edge e1, int segIndex1) {
        if (e0 == e1 && this.li.getIntersectionNum() == 1) {
            if (SegmentIntersector.isAdjacentSegments(segIndex0, segIndex1)) {
                return true;
            }
            if (e0.isClosed()) {
                int maxSegIndex = e0.getNumPoints() - 1;
                if (segIndex0 == 0 && segIndex1 == maxSegIndex || segIndex1 == 0 && segIndex0 == maxSegIndex) {
                    return true;
                }
            }
        }
        return false;
    }

    public void addIntersections(Edge e0, int segIndex0, Edge e1, int segIndex1) {
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        ++this.numTests;
        Coordinate p00 = e0.getCoordinates()[segIndex0];
        Coordinate p01 = e0.getCoordinates()[segIndex0 + 1];
        Coordinate p10 = e1.getCoordinates()[segIndex1];
        Coordinate p11 = e1.getCoordinates()[segIndex1 + 1];
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection()) {
            if (this.recordIsolated) {
                e0.setIsolated(false);
                e1.setIsolated(false);
            }
            ++this.numIntersections;
            if (!this.isTrivialIntersection(e0, segIndex0, e1, segIndex1)) {
                this.hasIntersection = true;
                if (this.includeProper || !this.li.isProper()) {
                    e0.addIntersections(this.li, segIndex0, 0);
                    e1.addIntersections(this.li, segIndex1, 1);
                }
                if (this.li.isProper()) {
                    this.properIntersectionPoint = (Coordinate)this.li.getIntersection(0).clone();
                    this.hasProper = true;
                    if (!this.isBoundaryPoint(this.li, this.bdyNodes)) {
                        this.hasProperInterior = true;
                    }
                }
            }
        }
    }

    private boolean isBoundaryPoint(LineIntersector li2, Collection[] bdyNodes) {
        if (bdyNodes == null) {
            return false;
        }
        if (this.isBoundaryPoint(li2, bdyNodes[0])) {
            return true;
        }
        return this.isBoundaryPoint(li2, bdyNodes[1]);
    }

    private boolean isBoundaryPoint(LineIntersector li2, Collection bdyNodes) {
        for (Node node : bdyNodes) {
            Coordinate pt2 = node.getCoordinate();
            if (!li2.isIntersection(pt2)) continue;
            return true;
        }
        return false;
    }
}

