/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.NodeFactory;
import com.vividsolutions.jts.geomgraph.NodeMap;
import com.vividsolutions.jts.geomgraph.Quadrant;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PlanarGraph {
    protected List edges = new ArrayList();
    protected NodeMap nodes;
    protected List edgeEndList = new ArrayList();

    public static void linkResultDirectedEdges(Collection nodes) {
        for (Node node : nodes) {
            ((DirectedEdgeStar)node.getEdges()).linkResultDirectedEdges();
        }
    }

    public PlanarGraph(NodeFactory nodeFact) {
        this.nodes = new NodeMap(nodeFact);
    }

    public PlanarGraph() {
        this.nodes = new NodeMap(new NodeFactory());
    }

    public Iterator getEdgeIterator() {
        return this.edges.iterator();
    }

    public Collection getEdgeEnds() {
        return this.edgeEndList;
    }

    public boolean isBoundaryNode(int geomIndex, Coordinate coord) {
        Node node = this.nodes.find(coord);
        if (node == null) {
            return false;
        }
        Label label = node.getLabel();
        return label != null && label.getLocation(geomIndex) == 1;
    }

    protected void insertEdge(Edge e2) {
        this.edges.add(e2);
    }

    public void add(EdgeEnd e2) {
        this.nodes.add(e2);
        this.edgeEndList.add(e2);
    }

    public Iterator getNodeIterator() {
        return this.nodes.iterator();
    }

    public Collection getNodes() {
        return this.nodes.values();
    }

    public Node addNode(Node node) {
        return this.nodes.addNode(node);
    }

    public Node addNode(Coordinate coord) {
        return this.nodes.addNode(coord);
    }

    public Node find(Coordinate coord) {
        return this.nodes.find(coord);
    }

    public void addEdges(List edgesToAdd) {
        for (Edge e2 : edgesToAdd) {
            this.edges.add(e2);
            DirectedEdge de1 = new DirectedEdge(e2, true);
            DirectedEdge de2 = new DirectedEdge(e2, false);
            de1.setSym(de2);
            de2.setSym(de1);
            this.add(de1);
            this.add(de2);
        }
    }

    public void linkResultDirectedEdges() {
        Iterator nodeit = this.nodes.iterator();
        while (nodeit.hasNext()) {
            Node node = (Node)nodeit.next();
            ((DirectedEdgeStar)node.getEdges()).linkResultDirectedEdges();
        }
    }

    public void linkAllDirectedEdges() {
        Iterator nodeit = this.nodes.iterator();
        while (nodeit.hasNext()) {
            Node node = (Node)nodeit.next();
            ((DirectedEdgeStar)node.getEdges()).linkAllDirectedEdges();
        }
    }

    public EdgeEnd findEdgeEnd(Edge e2) {
        for (EdgeEnd ee2 : this.getEdgeEnds()) {
            if (ee2.getEdge() != e2) continue;
            return ee2;
        }
        return null;
    }

    public Edge findEdge(Coordinate p0, Coordinate p1) {
        for (int i2 = 0; i2 < this.edges.size(); ++i2) {
            Edge e2 = (Edge)this.edges.get(i2);
            Coordinate[] eCoord = e2.getCoordinates();
            if (!p0.equals(eCoord[0]) || !p1.equals(eCoord[1])) continue;
            return e2;
        }
        return null;
    }

    public Edge findEdgeInSameDirection(Coordinate p0, Coordinate p1) {
        for (int i2 = 0; i2 < this.edges.size(); ++i2) {
            Edge e2 = (Edge)this.edges.get(i2);
            Coordinate[] eCoord = e2.getCoordinates();
            if (this.matchInSameDirection(p0, p1, eCoord[0], eCoord[1])) {
                return e2;
            }
            if (!this.matchInSameDirection(p0, p1, eCoord[eCoord.length - 1], eCoord[eCoord.length - 2])) continue;
            return e2;
        }
        return null;
    }

    private boolean matchInSameDirection(Coordinate p0, Coordinate p1, Coordinate ep0, Coordinate ep1) {
        if (!p0.equals(ep0)) {
            return false;
        }
        return CGAlgorithms.computeOrientation(p0, p1, ep1) == 0 && Quadrant.quadrant(p0, p1) == Quadrant.quadrant(ep0, ep1);
    }

    public void printEdges(PrintStream out) {
        out.println("Edges:");
        for (int i2 = 0; i2 < this.edges.size(); ++i2) {
            out.println("edge " + i2 + ":");
            Edge e2 = (Edge)this.edges.get(i2);
            e2.print(out);
            e2.eiList.print(out);
        }
    }

    void debugPrint(Object o2) {
        System.out.print(o2);
    }

    void debugPrintln(Object o2) {
        System.out.println(o2);
    }
}

