/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.util.ComponentCoordinateExtracter;
import java.util.List;

class BasicPreparedGeometry
implements PreparedGeometry {
    private Geometry baseGeom;
    private List representativePts;

    public BasicPreparedGeometry(Geometry geom) {
        this.baseGeom = geom;
        this.representativePts = ComponentCoordinateExtracter.getCoordinates(geom);
    }

    public Geometry getGeometry() {
        return this.baseGeom;
    }

    public List getRepresentativePoints() {
        return this.representativePts;
    }

    public boolean isAnyTargetComponentInTest(Geometry testGeom) {
        PointLocator locator = new PointLocator();
        for (Coordinate p2 : this.representativePts) {
            if (!locator.intersects(p2, testGeom)) continue;
            return true;
        }
        return false;
    }

    protected boolean envelopesIntersect(Geometry g2) {
        return this.baseGeom.getEnvelopeInternal().intersects(g2.getEnvelopeInternal());
    }

    protected boolean envelopeCovers(Geometry g2) {
        return this.baseGeom.getEnvelopeInternal().covers(g2.getEnvelopeInternal());
    }

    public boolean contains(Geometry g2) {
        return this.baseGeom.contains(g2);
    }

    public boolean containsProperly(Geometry g2) {
        if (!this.baseGeom.getEnvelopeInternal().contains(g2.getEnvelopeInternal())) {
            return false;
        }
        return this.baseGeom.relate(g2, "T**FF*FF*");
    }

    public boolean coveredBy(Geometry g2) {
        return this.baseGeom.coveredBy(g2);
    }

    public boolean covers(Geometry g2) {
        return this.baseGeom.covers(g2);
    }

    public boolean crosses(Geometry g2) {
        return this.baseGeom.crosses(g2);
    }

    public boolean disjoint(Geometry g2) {
        return !this.intersects(g2);
    }

    public boolean intersects(Geometry g2) {
        return this.baseGeom.intersects(g2);
    }

    public boolean overlaps(Geometry g2) {
        return this.baseGeom.overlaps(g2);
    }

    public boolean touches(Geometry g2) {
        return this.baseGeom.touches(g2);
    }

    public boolean within(Geometry g2) {
        return this.baseGeom.within(g2);
    }

    public String toString() {
        return this.baseGeom.toString();
    }
}

