/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;

public class MultiPolygon
extends GeometryCollection
implements Polygonal {
    private static final long serialVersionUID = -551033529766975875L;

    public MultiPolygon(Polygon[] polygons, PrecisionModel precisionModel, int SRID) {
        this(polygons, new GeometryFactory(precisionModel, SRID));
    }

    public MultiPolygon(Polygon[] polygons, GeometryFactory factory) {
        super(polygons, factory);
    }

    public int getDimension() {
        return 2;
    }

    public int getBoundaryDimension() {
        return 1;
    }

    public String getGeometryType() {
        return "MultiPolygon";
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString(null);
        }
        ArrayList<Geometry> allRings = new ArrayList<Geometry>();
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            Polygon polygon = (Polygon)this.geometries[i2];
            Geometry rings = polygon.getBoundary();
            for (int j2 = 0; j2 < rings.getNumGeometries(); ++j2) {
                allRings.add(rings.getGeometryN(j2));
            }
        }
        LineString[] allRingsArray = new LineString[allRings.size()];
        return this.getFactory().createMultiLineString(allRings.toArray(allRingsArray));
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        return super.equalsExact(other, tolerance);
    }

    public Geometry reverse() {
        int n2 = this.geometries.length;
        Polygon[] revGeoms = new Polygon[n2];
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            revGeoms[i2] = (Polygon)this.geometries[i2].reverse();
        }
        return this.getFactory().createMultiPolygon(revGeoms);
    }
}

