/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.BoundaryOp;

public class LineString
extends Geometry
implements Lineal {
    private static final long serialVersionUID = 3110669828065365560L;
    protected CoordinateSequence points;

    public LineString(Coordinate[] points, PrecisionModel precisionModel, int SRID) {
        super(new GeometryFactory(precisionModel, SRID));
        this.init(this.getFactory().getCoordinateSequenceFactory().create(points));
    }

    public LineString(CoordinateSequence points, GeometryFactory factory) {
        super(factory);
        this.init(points);
    }

    private void init(CoordinateSequence points) {
        if (points == null) {
            points = this.getFactory().getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        if (points.size() == 1) {
            throw new IllegalArgumentException("Invalid number of points in LineString (found " + points.size() + " - must be 0 or >= 2)");
        }
        this.points = points;
    }

    public Coordinate[] getCoordinates() {
        return this.points.toCoordinateArray();
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.points;
    }

    public Coordinate getCoordinateN(int n2) {
        return this.points.getCoordinate(n2);
    }

    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.points.getCoordinate(0);
    }

    public int getDimension() {
        return 1;
    }

    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    public int getNumPoints() {
        return this.points.size();
    }

    public Point getPointN(int n2) {
        return this.getFactory().createPoint(this.points.getCoordinate(n2));
    }

    public Point getStartPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(0);
    }

    public Point getEndPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(this.getNumPoints() - 1);
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getCoordinateN(0).equals2D(this.getCoordinateN(this.getNumPoints() - 1));
    }

    public boolean isRing() {
        return this.isClosed() && this.isSimple();
    }

    public String getGeometryType() {
        return "LineString";
    }

    public double getLength() {
        return CGAlgorithms.length(this.points);
    }

    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    public Geometry reverse() {
        CoordinateSequence seq = (CoordinateSequence)this.points.clone();
        CoordinateSequences.reverse(seq);
        LineString revLine = this.getFactory().createLineString(seq);
        return revLine;
    }

    public boolean isCoordinate(Coordinate pt2) {
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            if (!this.points.getCoordinate(i2).equals(pt2)) continue;
            return true;
        }
        return false;
    }

    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        return this.points.expandEnvelope(new Envelope());
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        LineString otherLineString = (LineString)other;
        if (this.points.size() != otherLineString.points.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            if (this.equal(this.points.getCoordinate(i2), otherLineString.points.getCoordinate(i2), tolerance)) continue;
            return false;
        }
        return true;
    }

    public void apply(CoordinateFilter filter) {
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            filter.filter(this.points.getCoordinate(i2));
        }
    }

    public void apply(CoordinateSequenceFilter filter) {
        if (this.points.size() == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            filter.filter(this.points, i2);
            if (filter.isDone()) break;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    public void apply(GeometryFilter filter) {
        filter.filter(this);
    }

    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
    }

    public Object clone() {
        LineString ls2 = (LineString)super.clone();
        ls2.points = (CoordinateSequence)this.points.clone();
        return ls2;
    }

    public void normalize() {
        for (int i2 = 0; i2 < this.points.size() / 2; ++i2) {
            int j2 = this.points.size() - 1 - i2;
            if (this.points.getCoordinate(i2).equals(this.points.getCoordinate(j2))) continue;
            if (this.points.getCoordinate(i2).compareTo(this.points.getCoordinate(j2)) > 0) {
                CoordinateArrays.reverse(this.getCoordinates());
            }
            return;
        }
    }

    protected boolean isEquivalentClass(Geometry other) {
        return other instanceof LineString;
    }

    protected int compareToSameClass(Object o2) {
        int j2;
        LineString line = (LineString)o2;
        int i2 = 0;
        for (j2 = 0; i2 < this.points.size() && j2 < line.points.size(); ++i2, ++j2) {
            int comparison = this.points.getCoordinate(i2).compareTo(line.points.getCoordinate(j2));
            if (comparison == 0) continue;
            return comparison;
        }
        if (i2 < this.points.size()) {
            return 1;
        }
        if (j2 < line.points.size()) {
            return -1;
        }
        return 0;
    }

    protected int compareToSameClass(Object o2, CoordinateSequenceComparator comp) {
        LineString line = (LineString)o2;
        return comp.compare(this.points, line.points);
    }
}

