/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;
import java.util.Comparator;

public class Coordinate
implements Comparable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6683108902428366910L;
    public static final double NULL_ORDINATE = Double.NaN;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public double x;
    public double y;
    public double z;

    public Coordinate(double x2, double y2, double z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public Coordinate() {
        this(0.0, 0.0);
    }

    public Coordinate(Coordinate c2) {
        this(c2.x, c2.y, c2.z);
    }

    public Coordinate(double x2, double y2) {
        this(x2, y2, Double.NaN);
    }

    public void setCoordinate(Coordinate other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public double getOrdinate(int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
    }

    public void setOrdinate(int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
            }
        }
    }

    public boolean equals2D(Coordinate other) {
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Coordinate)) {
            return false;
        }
        return this.equals2D((Coordinate)other);
    }

    public int compareTo(Object o2) {
        Coordinate other = (Coordinate)o2;
        if (this.x < other.x) {
            return -1;
        }
        if (this.x > other.x) {
            return 1;
        }
        if (this.y < other.y) {
            return -1;
        }
        if (this.y > other.y) {
            return 1;
        }
        return 0;
    }

    public boolean equals3D(Coordinate other) {
        return this.x == other.x && this.y == other.y && (this.z == other.z || Double.isNaN(this.z) && Double.isNaN(other.z));
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Object clone() {
        try {
            Coordinate coord = (Coordinate)super.clone();
            return coord;
        }
        catch (CloneNotSupportedException e2) {
            Assert.shouldNeverReachHere("this shouldn't happen because this class is Cloneable");
            return null;
        }
    }

    public double distance(Coordinate p2) {
        double dx2 = this.x - p2.x;
        double dy2 = this.y - p2.y;
        return Math.sqrt(dx2 * dx2 + dy2 * dy2);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + Coordinate.hashCode(this.x);
        result = 37 * result + Coordinate.hashCode(this.y);
        return result;
    }

    public static int hashCode(double x2) {
        long f2 = Double.doubleToLongBits(x2);
        return (int)(f2 ^ f2 >>> 32);
    }

    public static class DimensionalComparator
    implements Comparator {
        private int dimensionsToTest = 2;

        public static int compare(double a2, double b2) {
            if (a2 < b2) {
                return -1;
            }
            if (a2 > b2) {
                return 1;
            }
            if (Double.isNaN(a2)) {
                if (Double.isNaN(b2)) {
                    return 0;
                }
                return -1;
            }
            if (Double.isNaN(b2)) {
                return 1;
            }
            return 0;
        }

        public DimensionalComparator() {
            this(2);
        }

        public DimensionalComparator(int dimensionsToTest) {
            if (dimensionsToTest != 2 && dimensionsToTest != 3) {
                throw new IllegalArgumentException("only 2 or 3 dimensions may be specified");
            }
            this.dimensionsToTest = dimensionsToTest;
        }

        public int compare(Object o1, Object o2) {
            Coordinate c1 = (Coordinate)o1;
            Coordinate c2 = (Coordinate)o2;
            int compX = DimensionalComparator.compare(c1.x, c2.x);
            if (compX != 0) {
                return compX;
            }
            int compY = DimensionalComparator.compare(c1.y, c2.y);
            if (compY != 0) {
                return compY;
            }
            if (this.dimensionsToTest <= 2) {
                return 0;
            }
            int compZ = DimensionalComparator.compare(c1.z, c2.z);
            return compZ;
        }
    }
}

