/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;

public class InteriorPointPoint {
    private Coordinate centroid;
    private double minDistance = Double.MAX_VALUE;
    private Coordinate interiorPoint = null;

    public InteriorPointPoint(Geometry g2) {
        this.centroid = g2.getCentroid().getCoordinate();
        this.add(g2);
    }

    private void add(Geometry geom) {
        if (geom instanceof Point) {
            this.add(geom.getCoordinate());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc2 = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
                this.add(gc2.getGeometryN(i2));
            }
        }
    }

    private void add(Coordinate point) {
        double dist = point.distance(this.centroid);
        if (dist < this.minDistance) {
            this.interiorPoint = new Coordinate(point);
            this.minDistance = dist;
        }
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }
}

