/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.geom.Coordinate;

public class HCoordinate {
    public double x;
    public double y;
    public double w;

    public static Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) throws NotRepresentableException {
        double px2 = p1.y - p2.y;
        double py2 = p2.x - p1.x;
        double pw2 = p1.x * p2.y - p2.x * p1.y;
        double qx = q1.y - q2.y;
        double qy = q2.x - q1.x;
        double qw = q1.x * q2.y - q2.x * q1.y;
        double x2 = py2 * qw - qy * pw2;
        double y2 = qx * pw2 - px2 * qw;
        double w2 = px2 * qy - qx * py2;
        double xInt = x2 / w2;
        double yInt = y2 / w2;
        if (Double.isNaN(xInt) || Double.isInfinite(xInt) || Double.isNaN(yInt) || Double.isInfinite(yInt)) {
            throw new NotRepresentableException();
        }
        return new Coordinate(xInt, yInt);
    }

    public HCoordinate() {
        this.x = 0.0;
        this.y = 0.0;
        this.w = 1.0;
    }

    public HCoordinate(double _x, double _y, double _w) {
        this.x = _x;
        this.y = _y;
        this.w = _w;
    }

    public HCoordinate(double _x, double _y) {
        this.x = _x;
        this.y = _y;
        this.w = 1.0;
    }

    public HCoordinate(Coordinate p2) {
        this.x = p2.x;
        this.y = p2.y;
        this.w = 1.0;
    }

    public HCoordinate(HCoordinate p1, HCoordinate p2) {
        this.x = p1.y * p2.w - p2.y * p1.w;
        this.y = p2.x * p1.w - p1.x * p2.w;
        this.w = p1.x * p2.y - p2.x * p1.y;
    }

    public HCoordinate(Coordinate p1, Coordinate p2) {
        this.x = p1.y - p2.y;
        this.y = p2.x - p1.x;
        this.w = p1.x * p2.y - p2.x * p1.y;
    }

    public HCoordinate(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        double px2 = p1.y - p2.y;
        double py2 = p2.x - p1.x;
        double pw2 = p1.x * p2.y - p2.x * p1.y;
        double qx = q1.y - q2.y;
        double qy = q2.x - q1.x;
        double qw = q1.x * q2.y - q2.x * q1.y;
        this.x = py2 * qw - qy * pw2;
        this.y = qx * pw2 - px2 * qw;
        this.w = px2 * qy - qx * py2;
    }

    public double getX() throws NotRepresentableException {
        double a2 = this.x / this.w;
        if (Double.isNaN(a2) || Double.isInfinite(a2)) {
            throw new NotRepresentableException();
        }
        return a2;
    }

    public double getY() throws NotRepresentableException {
        double a2 = this.y / this.w;
        if (Double.isNaN(a2) || Double.isInfinite(a2)) {
            throw new NotRepresentableException();
        }
        return a2;
    }

    public Coordinate getCoordinate() throws NotRepresentableException {
        Coordinate p2 = new Coordinate();
        p2.x = this.getX();
        p2.y = this.getY();
        return p2;
    }
}

