/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;

public class CentroidPoint {
    private int ptCount = 0;
    private Coordinate centSum = new Coordinate();

    public void add(Geometry geom) {
        if (geom instanceof Point) {
            this.add(geom.getCoordinate());
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc2 = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
                this.add(gc2.getGeometryN(i2));
            }
        }
    }

    public void add(Coordinate pt2) {
        ++this.ptCount;
        this.centSum.x += pt2.x;
        this.centSum.y += pt2.y;
    }

    public Coordinate getCentroid() {
        Coordinate cent = new Coordinate();
        cent.x = this.centSum.x / (double)this.ptCount;
        cent.y = this.centSum.y / (double)this.ptCount;
        return cent;
    }
}

