/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithmsDD;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.math.MathUtil;

public class CGAlgorithms {
    public static final int CLOCKWISE = -1;
    public static final int RIGHT = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int LEFT = 1;
    public static final int COLLINEAR = 0;
    public static final int STRAIGHT = 0;

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q2) {
        return CGAlgorithmsDD.orientationIndex(p1, p2, q2);
    }

    public static boolean isPointInRing(Coordinate p2, Coordinate[] ring) {
        return CGAlgorithms.locatePointInRing(p2, ring) != 2;
    }

    public static int locatePointInRing(Coordinate p2, Coordinate[] ring) {
        return RayCrossingCounter.locatePointInRing(p2, ring);
    }

    public static boolean isOnLine(Coordinate p2, Coordinate[] pt2) {
        RobustLineIntersector lineIntersector = new RobustLineIntersector();
        for (int i2 = 1; i2 < pt2.length; ++i2) {
            Coordinate p0 = pt2[i2 - 1];
            Coordinate p1 = pt2[i2];
            ((LineIntersector)lineIntersector).computeIntersection(p2, p0, p1);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    public static boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 3 points, so orientation cannot be determined");
        }
        Coordinate hiPt = ring[0];
        int hiIndex = 0;
        for (int i2 = 1; i2 <= nPts; ++i2) {
            Coordinate p2 = ring[i2];
            if (!(p2.y > hiPt.y)) continue;
            hiPt = p2;
            hiIndex = i2;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (ring[iPrev].equals2D(hiPt) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (ring[iNext = (iNext + 1) % nPts].equals2D(hiPt) && iNext != hiIndex) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals2D(hiPt) || next.equals2D(hiPt) || prev.equals2D(next)) {
            return false;
        }
        int disc = CGAlgorithms.computeOrientation(prev, hiPt, next);
        boolean isCCW = false;
        isCCW = disc == 0 ? prev.x > next.x : disc > 0;
        return isCCW;
    }

    public static int computeOrientation(Coordinate p1, Coordinate p2, Coordinate q2) {
        return CGAlgorithms.orientationIndex(p1, p2, q2);
    }

    public static double distancePointLine(Coordinate p2, Coordinate A2, Coordinate B2) {
        if (A2.x == B2.x && A2.y == B2.y) {
            return p2.distance(A2);
        }
        double len2 = (B2.x - A2.x) * (B2.x - A2.x) + (B2.y - A2.y) * (B2.y - A2.y);
        double r2 = ((p2.x - A2.x) * (B2.x - A2.x) + (p2.y - A2.y) * (B2.y - A2.y)) / len2;
        if (r2 <= 0.0) {
            return p2.distance(A2);
        }
        if (r2 >= 1.0) {
            return p2.distance(B2);
        }
        double s2 = ((A2.y - p2.y) * (B2.x - A2.x) - (A2.x - p2.x) * (B2.y - A2.y)) / len2;
        return Math.abs(s2) * Math.sqrt(len2);
    }

    public static double distancePointLinePerpendicular(Coordinate p2, Coordinate A2, Coordinate B2) {
        double len2 = (B2.x - A2.x) * (B2.x - A2.x) + (B2.y - A2.y) * (B2.y - A2.y);
        double s2 = ((A2.y - p2.y) * (B2.x - A2.x) - (A2.x - p2.x) * (B2.y - A2.y)) / len2;
        return Math.abs(s2) * Math.sqrt(len2);
    }

    public static double distancePointLine(Coordinate p2, Coordinate[] line) {
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p2.distance(line[0]);
        for (int i2 = 0; i2 < line.length - 1; ++i2) {
            double dist = CGAlgorithms.distancePointLine(p2, line[i2], line[i2 + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public static double distanceLineLine(Coordinate A2, Coordinate B2, Coordinate C2, Coordinate D2) {
        if (A2.equals(B2)) {
            return CGAlgorithms.distancePointLine(A2, C2, D2);
        }
        if (C2.equals(D2)) {
            return CGAlgorithms.distancePointLine(D2, A2, B2);
        }
        boolean noIntersection = false;
        if (!Envelope.intersects(A2, B2, C2, D2)) {
            noIntersection = true;
        } else {
            double denom = (B2.x - A2.x) * (D2.y - C2.y) - (B2.y - A2.y) * (D2.x - C2.x);
            if (denom == 0.0) {
                noIntersection = true;
            } else {
                double r_num = (A2.y - C2.y) * (D2.x - C2.x) - (A2.x - C2.x) * (D2.y - C2.y);
                double s_num = (A2.y - C2.y) * (B2.x - A2.x) - (A2.x - C2.x) * (B2.y - A2.y);
                double s2 = s_num / denom;
                double r2 = r_num / denom;
                if (r2 < 0.0 || r2 > 1.0 || s2 < 0.0 || s2 > 1.0) {
                    noIntersection = true;
                }
            }
        }
        if (noIntersection) {
            return MathUtil.min(CGAlgorithms.distancePointLine(A2, C2, D2), CGAlgorithms.distancePointLine(B2, C2, D2), CGAlgorithms.distancePointLine(C2, A2, B2), CGAlgorithms.distancePointLine(D2, A2, B2));
        }
        return 0.0;
    }

    public static double signedArea(Coordinate[] ring) {
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        double x0 = ring[0].x;
        for (int i2 = 1; i2 < ring.length - 1; ++i2) {
            double x2 = ring[i2].x - x0;
            double y1 = ring[i2 + 1].y;
            double y2 = ring[i2 - 1].y;
            sum += x2 * (y2 - y1);
        }
        return sum / 2.0;
    }

    public static double signedArea(CoordinateSequence ring) {
        int n2 = ring.size();
        if (n2 < 3) {
            return 0.0;
        }
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        Coordinate p2 = new Coordinate();
        ring.getCoordinate(0, p1);
        ring.getCoordinate(1, p2);
        double x0 = p1.x;
        p2.x -= x0;
        double sum = 0.0;
        for (int i2 = 1; i2 < n2 - 1; ++i2) {
            p0.y = p1.y;
            p1.x = p2.x;
            p1.y = p2.y;
            ring.getCoordinate(i2 + 1, p2);
            p2.x -= x0;
            sum += p1.x * (p0.y - p2.y);
        }
        return sum / 2.0;
    }

    public static double length(CoordinateSequence pts) {
        int n2 = pts.size();
        if (n2 <= 1) {
            return 0.0;
        }
        double len = 0.0;
        Coordinate p2 = new Coordinate();
        pts.getCoordinate(0, p2);
        double x0 = p2.x;
        double y0 = p2.y;
        for (int i2 = 1; i2 < n2; ++i2) {
            pts.getCoordinate(i2, p2);
            double x1 = p2.x;
            double y1 = p2.y;
            double dx2 = x1 - x0;
            double dy2 = y1 - y0;
            len += Math.sqrt(dx2 * dx2 + dy2 * dy2);
            x0 = x1;
            y0 = y1;
        }
        return len;
    }
}

