/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.sw;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrImage;
import com.sun.scenario.effect.impl.prism.PrRenderer;
import com.sun.scenario.effect.impl.prism.sw.PSWDrawable;
import com.sun.scenario.effect.impl.sw.RendererDelegate;
import java.lang.reflect.Constructor;

public class PSWRenderer
extends PrRenderer {
    private final Screen screen;
    private final ResourceFactory resourceFactory;
    private final RendererDelegate delegate;
    private Renderer.RendererState state;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PSWRenderer(Screen screen, RendererDelegate rendererDelegate) {
        this.screen = screen;
        this.resourceFactory = null;
        this.delegate = rendererDelegate;
        PSWRenderer pSWRenderer = this;
        synchronized (pSWRenderer) {
            this.state = Renderer.RendererState.OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PSWRenderer(ResourceFactory resourceFactory, RendererDelegate rendererDelegate) {
        this.screen = null;
        this.resourceFactory = resourceFactory;
        this.delegate = rendererDelegate;
        PSWRenderer pSWRenderer = this;
        synchronized (pSWRenderer) {
            this.state = Renderer.RendererState.OK;
        }
    }

    @Override
    public PrDrawable createDrawable(RTTexture rTTexture) {
        return PSWDrawable.create(rTTexture);
    }

    public static synchronized PSWRenderer createJSWInstance(Screen screen) {
        PSWRenderer pSWRenderer = null;
        try {
            Class<?> clazz = Class.forName("com.sun.scenario.effect.impl.sw.java.JSWRendererDelegate");
            RendererDelegate rendererDelegate = (RendererDelegate)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pSWRenderer = new PSWRenderer(screen, rendererDelegate);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pSWRenderer;
    }

    public static synchronized PSWRenderer createJSWInstance(ResourceFactory resourceFactory) {
        PSWRenderer pSWRenderer = null;
        try {
            Class<?> clazz = Class.forName("com.sun.scenario.effect.impl.sw.java.JSWRendererDelegate");
            RendererDelegate rendererDelegate = (RendererDelegate)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pSWRenderer = new PSWRenderer(resourceFactory, rendererDelegate);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pSWRenderer;
    }

    public static synchronized PSWRenderer createJSWInstance(FilterContext filterContext) {
        PSWRenderer pSWRenderer = null;
        try {
            ResourceFactory resourceFactory = (ResourceFactory)filterContext.getReferent();
            pSWRenderer = PSWRenderer.createJSWInstance(resourceFactory);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pSWRenderer;
    }

    private static synchronized PSWRenderer createSSEInstance(Screen screen) {
        PSWRenderer pSWRenderer = null;
        try {
            Class<?> clazz = Class.forName("com.sun.scenario.effect.impl.sw.sse.SSERendererDelegate");
            RendererDelegate rendererDelegate = (RendererDelegate)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pSWRenderer = new PSWRenderer(screen, rendererDelegate);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pSWRenderer;
    }

    public static Renderer createRenderer(FilterContext filterContext) {
        Object object = filterContext.getReferent();
        GraphicsPipeline graphicsPipeline = GraphicsPipeline.getPipeline();
        if (graphicsPipeline == null || !(object instanceof Screen)) {
            return null;
        }
        Screen screen = (Screen)object;
        PSWRenderer pSWRenderer = PSWRenderer.createSSEInstance(screen);
        if (pSWRenderer == null) {
            pSWRenderer = PSWRenderer.createJSWInstance(screen);
        }
        return pSWRenderer;
    }

    @Override
    public Effect.AccelType getAccelType() {
        return this.delegate.getAccelType();
    }

    @Override
    public synchronized Renderer.RendererState getRendererState() {
        return this.state;
    }

    @Override
    protected Renderer getBackupRenderer() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        PSWRenderer pSWRenderer = this;
        synchronized (pSWRenderer) {
            this.state = Renderer.RendererState.DISPOSED;
        }
    }

    protected final synchronized void markLost() {
        if (this.state == Renderer.RendererState.OK) {
            this.state = Renderer.RendererState.LOST;
        }
    }

    @Override
    public int getCompatibleWidth(int n2) {
        if (this.screen != null) {
            return PSWDrawable.getCompatibleWidth(this.screen, n2);
        }
        return this.resourceFactory.getRTTWidth(n2, Texture.WrapMode.CLAMP_TO_EDGE);
    }

    @Override
    public int getCompatibleHeight(int n2) {
        if (this.screen != null) {
            return PSWDrawable.getCompatibleHeight(this.screen, n2);
        }
        return this.resourceFactory.getRTTHeight(n2, Texture.WrapMode.CLAMP_TO_EDGE);
    }

    @Override
    public final PSWDrawable createCompatibleImage(int n2, int n3) {
        if (this.screen != null) {
            return PSWDrawable.create(this.screen, n2, n3);
        }
        RTTexture rTTexture = this.resourceFactory.createRTTexture(n2, n3, Texture.WrapMode.CLAMP_TO_EDGE);
        return PSWDrawable.create(rTTexture);
    }

    @Override
    public PSWDrawable getCompatibleImage(int n2, int n3) {
        PSWDrawable pSWDrawable = (PSWDrawable)super.getCompatibleImage(n2, n3);
        if (pSWDrawable == null) {
            this.markLost();
        }
        return pSWDrawable;
    }

    private EffectPeer createIntrinsicPeer(FilterContext filterContext, String string) {
        EffectPeer effectPeer;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.sun.scenario.effect.impl.prism.Pr" + string + "Peer");
            Constructor<?> constructor = clazz.getConstructor(FilterContext.class, Renderer.class, String.class);
            effectPeer = (EffectPeer)constructor.newInstance(filterContext, this, string);
        }
        catch (Exception exception) {
            return null;
        }
        return effectPeer;
    }

    private EffectPeer createPlatformPeer(FilterContext filterContext, String string, int n2) {
        EffectPeer effectPeer;
        String string2 = this.delegate.getPlatformPeerName(string, n2);
        try {
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getConstructor(FilterContext.class, Renderer.class, String.class);
            effectPeer = (EffectPeer)constructor.newInstance(filterContext, this, string);
        }
        catch (Exception exception) {
            System.err.println("Error: " + this.getAccelType() + " peer not found for: " + string + " due to error: " + exception.getMessage());
            return null;
        }
        return effectPeer;
    }

    @Override
    protected EffectPeer createPeer(FilterContext filterContext, String string, int n2) {
        if (PrRenderer.isIntrinsicPeer(string)) {
            return this.createIntrinsicPeer(filterContext, string);
        }
        return this.createPlatformPeer(filterContext, string, n2);
    }

    @Override
    public boolean isImageDataCompatible(ImageData imageData) {
        return this.getRendererState() == Renderer.RendererState.OK && imageData.getUntransformedImage() instanceof PSWDrawable;
    }

    @Override
    public void clearImage(Filterable filterable) {
        PSWDrawable pSWDrawable = (PSWDrawable)filterable;
        pSWDrawable.clear();
    }

    @Override
    public ImageData createImageData(FilterContext filterContext, Filterable filterable) {
        int n2;
        if (!(filterable instanceof PrImage)) {
            throw new IllegalArgumentException("Identity source must be PrImage");
        }
        Image image = ((PrImage)filterable).getImage();
        int n3 = image.getWidth();
        PSWDrawable pSWDrawable = this.createCompatibleImage(n3, n2 = image.getHeight());
        if (pSWDrawable == null) {
            return null;
        }
        Graphics graphics = pSWDrawable.createGraphics();
        ResourceFactory resourceFactory = graphics.getResourceFactory();
        Texture texture = resourceFactory.createTexture(image, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_TO_EDGE);
        graphics.drawTexture(texture, 0.0f, 0.0f, n3, n2);
        graphics.sync();
        texture.dispose();
        return new ImageData(filterContext, pSWDrawable, new Rectangle(n3, n2));
    }

    @Override
    public Filterable transform(FilterContext filterContext, Filterable filterable, BaseTransform baseTransform, Rectangle rectangle, Rectangle rectangle2) {
        PSWDrawable pSWDrawable = this.getCompatibleImage(rectangle2.width, rectangle2.height);
        if (pSWDrawable != null) {
            Graphics graphics = pSWDrawable.createGraphics();
            graphics.translate(-rectangle2.x, -rectangle2.y);
            graphics.transform(baseTransform);
            graphics.drawTexture(((PSWDrawable)filterable).getTextureObject(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return pSWDrawable;
    }

    @Override
    public ImageData transform(FilterContext filterContext, ImageData imageData, BaseTransform baseTransform, Rectangle rectangle, Rectangle rectangle2) {
        PSWDrawable pSWDrawable = this.getCompatibleImage(rectangle2.width, rectangle2.height);
        if (pSWDrawable != null) {
            PSWDrawable pSWDrawable2 = (PSWDrawable)imageData.getUntransformedImage();
            Graphics graphics = pSWDrawable.createGraphics();
            graphics.translate(-rectangle2.x, -rectangle2.y);
            graphics.transform(baseTransform);
            graphics.drawTexture(pSWDrawable2.getTextureObject(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        imageData.unref();
        return new ImageData(filterContext, pSWDrawable, rectangle2);
    }
}

