/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.marlin.Curve;
import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.Helpers;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.RendererContext;
import java.util.Arrays;

public final class TransformingPathConsumer2D {
    static final double CLIP_RECT_PADDING = 0.25;
    private final RendererContext rdrCtx;
    private final ClosedPathDetector cpDetector;
    private final PathClipFilter pathClipper;
    private final Path2DWrapper wp_Path2DWrapper = new Path2DWrapper();
    private final DeltaScaleFilter dt_DeltaScaleFilter = new DeltaScaleFilter();
    private final DeltaTransformFilter dt_DeltaTransformFilter = new DeltaTransformFilter();
    private final DeltaScaleFilter iv_DeltaScaleFilter = new DeltaScaleFilter();
    private final DeltaTransformFilter iv_DeltaTransformFilter = new DeltaTransformFilter();
    private final PathTracer tracerInput = new PathTracer("[Input]");
    private final PathTracer tracerCPDetector = new PathTracer("ClosedPathDetector");
    private final PathTracer tracerFiller = new PathTracer("Filler");
    private final PathTracer tracerStroker = new PathTracer("Stroker");
    private final PathTracer tracerDasher = new PathTracer("Dasher");

    TransformingPathConsumer2D(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.cpDetector = new ClosedPathDetector(rendererContext);
        this.pathClipper = new PathClipFilter(rendererContext);
    }

    public DPathConsumer2D wrapPath2D(Path2D path2D) {
        return this.wp_Path2DWrapper.init(path2D);
    }

    public DPathConsumer2D traceInput(DPathConsumer2D dPathConsumer2D) {
        return this.tracerInput.init(dPathConsumer2D);
    }

    public DPathConsumer2D traceClosedPathDetector(DPathConsumer2D dPathConsumer2D) {
        return this.tracerCPDetector.init(dPathConsumer2D);
    }

    public DPathConsumer2D traceFiller(DPathConsumer2D dPathConsumer2D) {
        return this.tracerFiller.init(dPathConsumer2D);
    }

    public DPathConsumer2D traceStroker(DPathConsumer2D dPathConsumer2D) {
        return this.tracerStroker.init(dPathConsumer2D);
    }

    public DPathConsumer2D traceDasher(DPathConsumer2D dPathConsumer2D) {
        return this.tracerDasher.init(dPathConsumer2D);
    }

    public DPathConsumer2D detectClosedPath(DPathConsumer2D dPathConsumer2D) {
        return this.cpDetector.init(dPathConsumer2D);
    }

    public DPathConsumer2D pathClipper(DPathConsumer2D dPathConsumer2D) {
        return this.pathClipper.init(dPathConsumer2D);
    }

    public DPathConsumer2D deltaTransformConsumer(DPathConsumer2D dPathConsumer2D, BaseTransform baseTransform) {
        if (baseTransform == null) {
            return dPathConsumer2D;
        }
        double d2 = baseTransform.getMxx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMyx();
        double d5 = baseTransform.getMyy();
        if (d3 == 0.0 && d4 == 0.0) {
            if (d2 == 1.0 && d5 == 1.0) {
                return dPathConsumer2D;
            }
            if (this.rdrCtx.doClip) {
                this.rdrCtx.clipInvScale = TransformingPathConsumer2D.adjustClipScale(this.rdrCtx.clipRect, d2, d5);
            }
            return this.dt_DeltaScaleFilter.init(dPathConsumer2D, d2, d5);
        }
        if (this.rdrCtx.doClip) {
            this.rdrCtx.clipInvScale = TransformingPathConsumer2D.adjustClipInverseDelta(this.rdrCtx.clipRect, d2, d3, d4, d5);
        }
        return this.dt_DeltaTransformFilter.init(dPathConsumer2D, d2, d3, d4, d5);
    }

    private static double adjustClipScale(double[] dArray, double d2, double d3) {
        double d4;
        double d5 = 1.0 / d3;
        dArray[0] = dArray[0] * d5;
        dArray[1] = dArray[1] * d5;
        if (dArray[1] < dArray[0]) {
            d4 = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = d4;
        }
        d4 = 1.0 / d2;
        dArray[2] = dArray[2] * d4;
        dArray[3] = dArray[3] * d4;
        if (dArray[3] < dArray[2]) {
            double d6 = dArray[2];
            dArray[2] = dArray[3];
            dArray[3] = d6;
        }
        if (MarlinConst.DO_LOG_CLIP) {
            MarlinUtils.logInfo("clipRect (ClipScale): " + Arrays.toString(dArray));
        }
        return 0.5 * (Math.abs(d4) + Math.abs(d5));
    }

    private static double adjustClipInverseDelta(double[] dArray, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8 = d2 * d5 - d3 * d4;
        double d9 = d5 / d8;
        double d10 = -d3 / d8;
        double d11 = -d4 / d8;
        double d12 = d2 / d8;
        double d13 = dArray[2] * d9 + dArray[0] * d10;
        double d14 = dArray[2] * d11 + dArray[0] * d12;
        double d15 = d7 = d13;
        double d16 = d6 = d14;
        d13 = dArray[3] * d9 + dArray[0] * d10;
        d14 = dArray[3] * d11 + dArray[0] * d12;
        if (d13 < d15) {
            d15 = d13;
        } else if (d13 > d7) {
            d7 = d13;
        }
        if (d14 < d16) {
            d16 = d14;
        } else if (d14 > d6) {
            d6 = d14;
        }
        d13 = dArray[2] * d9 + dArray[1] * d10;
        d14 = dArray[2] * d11 + dArray[1] * d12;
        if (d13 < d15) {
            d15 = d13;
        } else if (d13 > d7) {
            d7 = d13;
        }
        if (d14 < d16) {
            d16 = d14;
        } else if (d14 > d6) {
            d6 = d14;
        }
        d13 = dArray[3] * d9 + dArray[1] * d10;
        d14 = dArray[3] * d11 + dArray[1] * d12;
        if (d13 < d15) {
            d15 = d13;
        } else if (d13 > d7) {
            d7 = d13;
        }
        if (d14 < d16) {
            d16 = d14;
        } else if (d14 > d6) {
            d6 = d14;
        }
        dArray[0] = d16;
        dArray[1] = d6;
        dArray[2] = d15;
        dArray[3] = d7;
        if (MarlinConst.DO_LOG_CLIP) {
            MarlinUtils.logInfo("clipRect (ClipInverseDelta): " + Arrays.toString(dArray));
        }
        double d17 = Math.sqrt(d9 * d9 + d10 * d10);
        double d18 = Math.sqrt(d11 * d11 + d12 * d12);
        return 0.5 * (d17 + d18);
    }

    public DPathConsumer2D inverseDeltaTransformConsumer(DPathConsumer2D dPathConsumer2D, BaseTransform baseTransform) {
        if (baseTransform == null) {
            return dPathConsumer2D;
        }
        double d2 = baseTransform.getMxx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMyx();
        double d5 = baseTransform.getMyy();
        if (d3 == 0.0 && d4 == 0.0) {
            if (d2 == 1.0 && d5 == 1.0) {
                return dPathConsumer2D;
            }
            return this.iv_DeltaScaleFilter.init(dPathConsumer2D, 1.0 / d2, 1.0 / d5);
        }
        double d6 = d2 * d5 - d3 * d4;
        return this.iv_DeltaTransformFilter.init(dPathConsumer2D, d5 / d6, -d3 / d6, -d4 / d6, d2 / d6);
    }

    static final class Path2DWrapper
    implements DPathConsumer2D {
        private Path2D p2d;

        Path2DWrapper() {
        }

        Path2DWrapper init(Path2D path2D) {
            this.p2d = path2D;
            return this;
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.p2d.moveTo((float)d2, (float)d3);
        }

        @Override
        public void lineTo(double d2, double d3) {
            this.p2d.lineTo((float)d2, (float)d3);
        }

        @Override
        public void closePath() {
            this.p2d.closePath();
        }

        @Override
        public void pathDone() {
        }

        @Override
        public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.p2d.curveTo((float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7);
        }

        @Override
        public void quadTo(double d2, double d3, double d4, double d5) {
            this.p2d.quadTo((float)d2, (float)d3, (float)d4, (float)d5);
        }
    }

    static final class DeltaScaleFilter
    implements DPathConsumer2D {
        private DPathConsumer2D out;
        private double sx;
        private double sy;

        DeltaScaleFilter() {
        }

        DeltaScaleFilter init(DPathConsumer2D dPathConsumer2D, double d2, double d3) {
            this.out = dPathConsumer2D;
            this.sx = d2;
            this.sy = d3;
            return this;
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.out.moveTo(d2 * this.sx, d3 * this.sy);
        }

        @Override
        public void lineTo(double d2, double d3) {
            this.out.lineTo(d2 * this.sx, d3 * this.sy);
        }

        @Override
        public void quadTo(double d2, double d3, double d4, double d5) {
            this.out.quadTo(d2 * this.sx, d3 * this.sy, d4 * this.sx, d5 * this.sy);
        }

        @Override
        public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.out.curveTo(d2 * this.sx, d3 * this.sy, d4 * this.sx, d5 * this.sy, d6 * this.sx, d7 * this.sy);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }
    }

    static final class DeltaTransformFilter
    implements DPathConsumer2D {
        private DPathConsumer2D out;
        private double mxx;
        private double mxy;
        private double myx;
        private double myy;

        DeltaTransformFilter() {
        }

        DeltaTransformFilter init(DPathConsumer2D dPathConsumer2D, double d2, double d3, double d4, double d5) {
            this.out = dPathConsumer2D;
            this.mxx = d2;
            this.mxy = d3;
            this.myx = d4;
            this.myy = d5;
            return this;
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.out.moveTo(d2 * this.mxx + d3 * this.mxy, d2 * this.myx + d3 * this.myy);
        }

        @Override
        public void lineTo(double d2, double d3) {
            this.out.lineTo(d2 * this.mxx + d3 * this.mxy, d2 * this.myx + d3 * this.myy);
        }

        @Override
        public void quadTo(double d2, double d3, double d4, double d5) {
            this.out.quadTo(d2 * this.mxx + d3 * this.mxy, d2 * this.myx + d3 * this.myy, d4 * this.mxx + d5 * this.mxy, d4 * this.myx + d5 * this.myy);
        }

        @Override
        public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.out.curveTo(d2 * this.mxx + d3 * this.mxy, d2 * this.myx + d3 * this.myy, d4 * this.mxx + d5 * this.mxy, d4 * this.myx + d5 * this.myy, d6 * this.mxx + d7 * this.mxy, d6 * this.myx + d7 * this.myy);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }
    }

    static final class PathTracer
    implements DPathConsumer2D {
        private final String prefix;
        private DPathConsumer2D out;

        PathTracer(String string) {
            this.prefix = string + ": ";
        }

        PathTracer init(DPathConsumer2D dPathConsumer2D) {
            this.out = dPathConsumer2D;
            return this;
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.log("p.moveTo(" + d2 + ", " + d3 + ");");
            this.out.moveTo(d2, d3);
        }

        @Override
        public void lineTo(double d2, double d3) {
            this.log("p.lineTo(" + d2 + ", " + d3 + ");");
            this.out.lineTo(d2, d3);
        }

        @Override
        public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.log("p.curveTo(" + d2 + ", " + d3 + ", " + d4 + ", " + d5 + ", " + d6 + ", " + d7 + ");");
            this.out.curveTo(d2, d3, d4, d5, d6, d7);
        }

        @Override
        public void quadTo(double d2, double d3, double d4, double d5) {
            this.log("p.quadTo(" + d2 + ", " + d3 + ", " + d4 + ", " + d5 + ");");
            this.out.quadTo(d2, d3, d4, d5);
        }

        @Override
        public void closePath() {
            this.log("p.closePath();");
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.log("p.pathDone();");
            this.out.pathDone();
        }

        private void log(String string) {
            MarlinUtils.logInfo(this.prefix + string);
        }
    }

    static final class ClosedPathDetector
    implements DPathConsumer2D {
        private final RendererContext rdrCtx;
        private final Helpers.PolyStack stack;
        private DPathConsumer2D out;

        ClosedPathDetector(RendererContext rendererContext) {
            this.rdrCtx = rendererContext;
            this.stack = rendererContext.stats != null ? new Helpers.PolyStack(rendererContext, rendererContext.stats.stat_cpd_polystack_types, rendererContext.stats.stat_cpd_polystack_curves, rendererContext.stats.hist_cpd_polystack_curves, rendererContext.stats.stat_array_cpd_polystack_curves, rendererContext.stats.stat_array_cpd_polystack_types) : new Helpers.PolyStack(rendererContext);
        }

        ClosedPathDetector init(DPathConsumer2D dPathConsumer2D) {
            this.out = dPathConsumer2D;
            return this;
        }

        void dispose() {
            this.stack.dispose();
        }

        @Override
        public void pathDone() {
            this.finish(false);
            this.out.pathDone();
            this.dispose();
        }

        @Override
        public void closePath() {
            this.finish(true);
            this.out.closePath();
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.finish(false);
            this.out.moveTo(d2, d3);
        }

        private void finish(boolean bl2) {
            this.rdrCtx.closedPath = bl2;
            this.stack.pullAll(this.out);
        }

        @Override
        public void lineTo(double d2, double d3) {
            this.stack.pushLine(d2, d3);
        }

        @Override
        public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.stack.pushCubic(d6, d7, d4, d5, d2, d3);
        }

        @Override
        public void quadTo(double d2, double d3, double d4, double d5) {
            this.stack.pushQuad(d4, d5, d2, d3);
        }
    }

    static final class PathClipFilter
    implements DPathConsumer2D {
        private DPathConsumer2D out;
        private final double[] clipRect;
        private final double[] corners = new double[8];
        private boolean init_corners = false;
        private final Helpers.IndexStack stack;
        private int cOutCode = 0;
        private int gOutCode = 15;
        private boolean outside = false;
        private double sx0;
        private double sy0;
        private double cx0;
        private double cy0;
        private double cox0;
        private double coy0;
        private boolean subdivide = MarlinConst.DO_CLIP_SUBDIVIDER;
        private final CurveClipSplitter curveSplitter;

        PathClipFilter(RendererContext rendererContext) {
            this.clipRect = rendererContext.clipRect;
            this.curveSplitter = rendererContext.curveClipSplitter;
            this.stack = rendererContext.stats != null ? new Helpers.IndexStack(rendererContext, rendererContext.stats.stat_pcf_idxstack_indices, rendererContext.stats.hist_pcf_idxstack_indices, rendererContext.stats.stat_array_pcf_idxstack_indices) : new Helpers.IndexStack(rendererContext);
        }

        PathClipFilter init(DPathConsumer2D dPathConsumer2D) {
            this.out = dPathConsumer2D;
            if (MarlinConst.DO_CLIP_SUBDIVIDER) {
                this.curveSplitter.init();
            }
            this.init_corners = true;
            this.gOutCode = 15;
            return this;
        }

        void dispose() {
            this.stack.dispose();
        }

        private void finishPath() {
            if (this.outside) {
                if (this.gOutCode == 0) {
                    this.finish();
                } else {
                    this.outside = false;
                    this.stack.reset();
                }
            }
        }

        private void finish() {
            this.outside = false;
            if (!this.stack.isEmpty()) {
                if (this.init_corners) {
                    this.init_corners = false;
                    double[] dArray = this.corners;
                    double[] dArray2 = this.clipRect;
                    dArray[0] = dArray2[2];
                    dArray[1] = dArray2[0];
                    dArray[2] = dArray2[2];
                    dArray[3] = dArray2[1];
                    dArray[4] = dArray2[3];
                    dArray[5] = dArray2[0];
                    dArray[6] = dArray2[3];
                    dArray[7] = dArray2[1];
                }
                this.stack.pullAll(this.corners, this.out);
            }
            this.out.lineTo(this.cox0, this.coy0);
            this.cx0 = this.cox0;
            this.cy0 = this.coy0;
        }

        @Override
        public void pathDone() {
            this.finishPath();
            this.out.pathDone();
            this.dispose();
        }

        @Override
        public void closePath() {
            this.finishPath();
            this.out.closePath();
            this.cOutCode = Helpers.outcode(this.sx0, this.sy0, this.clipRect);
            this.cx0 = this.sx0;
            this.cy0 = this.sy0;
        }

        @Override
        public void moveTo(double d2, double d3) {
            this.finishPath();
            this.out.moveTo(d2, d3);
            this.cOutCode = Helpers.outcode(d2, d3, this.clipRect);
            this.cx0 = d2;
            this.cy0 = d3;
            this.sx0 = d2;
            this.sy0 = d3;
        }

        @Override
        public void lineTo(double d2, double d3) {
            int n2 = this.cOutCode;
            int n3 = Helpers.outcode(d2, d3, this.clipRect);
            int n4 = n2 | n3;
            if (n4 != 0) {
                int n5 = n2 & n3;
                if (n5 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.outside ? this.curveSplitter.splitLine(this.cox0, this.coy0, d2, d3, n4, this) : this.curveSplitter.splitLine(this.cx0, this.cy0, d2, d3, n4, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this.gOutCode &= n5;
                    this.outside = true;
                    this.cox0 = d2;
                    this.coy0 = d3;
                    this.clip(n5, n2, n3);
                    return;
                }
            }
            this.cOutCode = n3;
            this.gOutCode = 0;
            if (this.outside) {
                this.finish();
            }
            this.out.lineTo(d2, d3);
            this.cx0 = d2;
            this.cy0 = d3;
        }

        private void clip(int n2, int n3, int n4) {
            if (n3 != n4 && (n2 & 0xC) != 0) {
                int n5 = n3 | n4;
                int n6 = n5 & 3;
                int n7 = n5 & 0xC;
                int n8 = n7 == 4 ? 0 : 2;
                switch (n6) {
                    case 1: {
                        this.stack.push(n8);
                        return;
                    }
                    case 2: {
                        this.stack.push(n8 + 1);
                        return;
                    }
                }
                if ((n3 & 1) != 0) {
                    this.stack.push(n8);
                    this.stack.push(n8 + 1);
                } else {
                    this.stack.push(n8 + 1);
                    this.stack.push(n8);
                }
            }
        }

        @Override
        public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
            int n2;
            int n3;
            int n4 = this.cOutCode;
            int n5 = Helpers.outcode(d2, d3, this.clipRect);
            int n6 = n4 | n5 | (n3 = Helpers.outcode(d4, d5, this.clipRect)) | (n2 = Helpers.outcode(d6, d7, this.clipRect));
            if (n6 != 0) {
                int n7 = n4 & n5 & n3 & n2;
                if (n7 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.outside ? this.curveSplitter.splitCurve(this.cox0, this.coy0, d2, d3, d4, d5, d6, d7, n6, this) : this.curveSplitter.splitCurve(this.cx0, this.cy0, d2, d3, d4, d5, d6, d7, n6, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n2;
                    this.gOutCode &= n7;
                    this.outside = true;
                    this.cox0 = d6;
                    this.coy0 = d7;
                    this.clip(n7, n4, n2);
                    return;
                }
            }
            this.cOutCode = n2;
            this.gOutCode = 0;
            if (this.outside) {
                this.finish();
            }
            this.out.curveTo(d2, d3, d4, d5, d6, d7);
            this.cx0 = d6;
            this.cy0 = d7;
        }

        @Override
        public void quadTo(double d2, double d3, double d4, double d5) {
            int n2;
            int n3 = this.cOutCode;
            int n4 = Helpers.outcode(d2, d3, this.clipRect);
            int n5 = n3 | n4 | (n2 = Helpers.outcode(d4, d5, this.clipRect));
            if (n5 != 0) {
                int n6 = n3 & n4 & n2;
                if (n6 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.outside ? this.curveSplitter.splitQuad(this.cox0, this.coy0, d2, d3, d4, d5, n5, this) : this.curveSplitter.splitQuad(this.cx0, this.cy0, d2, d3, d4, d5, n5, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n2;
                    this.gOutCode &= n6;
                    this.outside = true;
                    this.cox0 = d4;
                    this.coy0 = d5;
                    this.clip(n6, n3, n2);
                    return;
                }
            }
            this.cOutCode = n2;
            this.gOutCode = 0;
            if (this.outside) {
                this.finish();
            }
            this.out.quadTo(d2, d3, d4, d5);
            this.cx0 = d4;
            this.cy0 = d5;
        }
    }

    public static final class CurveBasicMonotonizer {
        private static final int MAX_N_CURVES = 11;
        private double lw2;
        int nbSplits;
        final double[] middle = new double[68];
        private final double[] subdivTs = new double[10];
        private final Curve curve;

        CurveBasicMonotonizer(RendererContext rendererContext) {
            this.curve = rendererContext.curve;
        }

        public void init(double d2) {
            this.lw2 = d2 * d2 / 4.0;
        }

        CurveBasicMonotonizer curve(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
            double[] dArray = this.middle;
            dArray[0] = d2;
            dArray[1] = d3;
            dArray[2] = d4;
            dArray[3] = d5;
            dArray[4] = d6;
            dArray[5] = d7;
            dArray[6] = d8;
            dArray[7] = d9;
            double[] dArray2 = this.subdivTs;
            int n2 = Helpers.findSubdivPoints(this.curve, dArray, dArray2, 8, this.lw2);
            double d10 = 0.0;
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                double d11 = dArray2[n3];
                Helpers.subdivideCubicAt((d11 - d10) / (1.0 - d10), dArray, n4, dArray, n4, n4 + 6);
                d10 = d11;
                ++n3;
                n4 += 6;
            }
            this.nbSplits = n2;
            return this;
        }

        CurveBasicMonotonizer quad(double d2, double d3, double d4, double d5, double d6, double d7) {
            double[] dArray = this.middle;
            dArray[0] = d2;
            dArray[1] = d3;
            dArray[2] = d4;
            dArray[3] = d5;
            dArray[4] = d6;
            dArray[5] = d7;
            double[] dArray2 = this.subdivTs;
            int n2 = Helpers.findSubdivPoints(this.curve, dArray, dArray2, 6, this.lw2);
            double d8 = 0.0;
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                double d9 = dArray2[n3];
                Helpers.subdivideQuadAt((d9 - d8) / (1.0 - d8), dArray, n4, dArray, n4, n4 + 4);
                d8 = d9;
                ++n3;
                n4 += 4;
            }
            this.nbSplits = n2;
            return this;
        }
    }

    static final class CurveClipSplitter {
        static final double LEN_TH = MarlinProperties.getSubdividerMinLength();
        static final boolean DO_CHECK_LENGTH = LEN_TH > 0.0;
        private static final boolean TRACE = false;
        private static final int MAX_N_CURVES = 12;
        private final RendererContext rdrCtx;
        private double minLength;
        final double[] clipRect;
        final double[] clipRectPad = new double[4];
        private boolean init_clipRectPad = false;
        final double[] middle = new double[98];
        private final double[] subdivTs = new double[12];
        private final Curve curve;

        CurveClipSplitter(RendererContext rendererContext) {
            this.rdrCtx = rendererContext;
            this.clipRect = rendererContext.clipRect;
            this.curve = rendererContext.curve;
        }

        void init() {
            this.init_clipRectPad = true;
            if (DO_CHECK_LENGTH) {
                double d2 = this.minLength = this.rdrCtx.clipInvScale == 0.0 ? LEN_TH : LEN_TH * this.rdrCtx.clipInvScale;
                if (MarlinConst.DO_LOG_CLIP) {
                    MarlinUtils.logInfo("CurveClipSplitter.minLength = " + this.minLength);
                }
            }
        }

        private void initPaddedClip() {
            double[] dArray = this.clipRect;
            double[] dArray2 = this.clipRectPad;
            dArray2[0] = dArray[0] - 0.25;
            dArray2[1] = dArray[1] + 0.25;
            dArray2[2] = dArray[2] - 0.25;
            dArray2[3] = dArray[3] + 0.25;
        }

        boolean splitLine(double d2, double d3, double d4, double d5, int n2, DPathConsumer2D dPathConsumer2D) {
            if (DO_CHECK_LENGTH && Helpers.fastLineLen(d2, d3, d4, d5) <= this.minLength) {
                return false;
            }
            double[] dArray = this.middle;
            dArray[0] = d2;
            dArray[1] = d3;
            dArray[2] = d4;
            dArray[3] = d5;
            return this.subdivideAtIntersections(4, n2, dPathConsumer2D);
        }

        boolean splitQuad(double d2, double d3, double d4, double d5, double d6, double d7, int n2, DPathConsumer2D dPathConsumer2D) {
            if (DO_CHECK_LENGTH && Helpers.fastQuadLen(d2, d3, d4, d5, d6, d7) <= this.minLength) {
                return false;
            }
            double[] dArray = this.middle;
            dArray[0] = d2;
            dArray[1] = d3;
            dArray[2] = d4;
            dArray[3] = d5;
            dArray[4] = d6;
            dArray[5] = d7;
            return this.subdivideAtIntersections(6, n2, dPathConsumer2D);
        }

        boolean splitCurve(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n2, DPathConsumer2D dPathConsumer2D) {
            if (DO_CHECK_LENGTH && Helpers.fastCurvelen(d2, d3, d4, d5, d6, d7, d8, d9) <= this.minLength) {
                return false;
            }
            double[] dArray = this.middle;
            dArray[0] = d2;
            dArray[1] = d3;
            dArray[2] = d4;
            dArray[3] = d5;
            dArray[4] = d6;
            dArray[5] = d7;
            dArray[6] = d8;
            dArray[7] = d9;
            return this.subdivideAtIntersections(8, n2, dPathConsumer2D);
        }

        private boolean subdivideAtIntersections(int n2, int n3, DPathConsumer2D dPathConsumer2D) {
            int n4;
            double[] dArray = this.middle;
            double[] dArray2 = this.subdivTs;
            if (this.init_clipRectPad) {
                this.init_clipRectPad = false;
                this.initPaddedClip();
            }
            if ((n4 = Helpers.findClipPoints(this.curve, dArray, dArray2, n2, n3, this.clipRectPad)) == 0) {
                return false;
            }
            double d2 = 0.0;
            int n5 = 0;
            int n6 = 0;
            while (n5 < n4) {
                double d3 = dArray2[n5];
                Helpers.subdivideAt((d3 - d2) / (1.0 - d2), dArray, n6, dArray, n6, n2);
                d2 = d3;
                ++n5;
                n6 += n2;
            }
            n5 = 0;
            n6 = 0;
            while (n5 <= n4) {
                CurveClipSplitter.emitCurrent(n2, dArray, n6, dPathConsumer2D);
                ++n5;
                n6 += n2;
            }
            return true;
        }

        static void emitCurrent(int n2, double[] dArray, int n3, DPathConsumer2D dPathConsumer2D) {
            if (n2 == 8) {
                dPathConsumer2D.curveTo(dArray[n3 + 2], dArray[n3 + 3], dArray[n3 + 4], dArray[n3 + 5], dArray[n3 + 6], dArray[n3 + 7]);
            } else if (n2 == 4) {
                dPathConsumer2D.lineTo(dArray[n3 + 2], dArray[n3 + 3]);
            } else {
                dPathConsumer2D.quadTo(dArray[n3 + 2], dArray[n3 + 3], dArray[n3 + 4], dArray[n3 + 5]);
            }
        }
    }
}

