/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.FloatMath;
import com.sun.marlin.IntArrayCache;
import com.sun.marlin.MarlinAlphaConsumer;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.OffHeapArray;
import com.sun.prism.impl.shape.MaskData;
import java.nio.ByteBuffer;
import java.util.Arrays;
import sun.misc.Unsafe;

public final class MaskMarlinAlphaConsumer
implements MarlinAlphaConsumer {
    int x;
    int y;
    int width;
    int height;
    final byte[] alphas;
    final ByteBuffer alphabuffer;
    final MaskData maskdata = new MaskData();
    boolean useFastFill;
    int fastFillThreshold;
    OffHeapArray ALPHA_MAP_USED = null;
    static final byte[] ALPHA_MAP;
    static final OffHeapArray ALPHA_MAP_UNSAFE;
    static final byte[] ALPHA_MAP_NO_AA;
    static final OffHeapArray ALPHA_MAP_UNSAFE_NO_AA;

    public MaskMarlinAlphaConsumer(int n2) {
        this.alphas = new byte[n2];
        this.alphabuffer = ByteBuffer.wrap(this.alphas);
    }

    public void setBoundsNoClone(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        this.maskdata.update(this.alphabuffer, n2, n3, n4, n5);
        boolean bl2 = this.useFastFill = n4 >= 32;
        if (this.useFastFill) {
            this.fastFillThreshold = n4 >= 128 ? n4 >> 1 : n4 >> 2;
        }
    }

    @Override
    public int getOriginX() {
        return this.x;
    }

    @Override
    public int getOriginY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getAlphaLength() {
        return this.alphas.length;
    }

    public MaskData getMaskData() {
        return this.maskdata;
    }

    @Override
    public void setMaxAlpha(int n2) {
        this.ALPHA_MAP_USED = n2 == 1 ? ALPHA_MAP_UNSAFE_NO_AA : ALPHA_MAP_UNSAFE;
    }

    private static byte[] buildAlphaMap(int n2) {
        byte[] byArray = new byte[n2 << 1];
        int n3 = n2 >> 2;
        for (int i2 = 0; i2 <= n2; ++i2) {
            byArray[i2] = (byte)((i2 * 255 + n3) / n2);
        }
        return byArray;
    }

    @Override
    public boolean supportBlockFlags() {
        return true;
    }

    @Override
    public void clearAlphas(int n2) {
        int n3 = this.width;
        int n4 = (n2 - this.y) * n3;
        Arrays.fill(this.alphas, n4, n4 + n3, (byte)0);
    }

    @Override
    public void setAndClearRelativeAlphas(int[] nArray, int n2, int n3, int n4) {
        boolean bl2;
        byte[] byArray = this.alphas;
        int n5 = this.width;
        int n6 = (n2 - this.y) * n5;
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l2 = this.ALPHA_MAP_USED.address;
        int n7 = n3 - this.x;
        int n8 = n4 - this.x;
        int n9 = Math.min(n8, this.width);
        boolean bl3 = bl2 = this.useFastFill && n9 - n7 < this.fastFillThreshold;
        if (bl2) {
            Arrays.fill(byArray, n6, n6 + n5, (byte)0);
            int n10 = 0;
            for (int i2 = n7; i2 < n9; ++i2) {
                byArray[n6 + i2] = unsafe.getByte(l2 + (long)(n10 += nArray[i2]));
            }
        } else {
            int n11;
            for (n11 = 0; n11 < n7; ++n11) {
                byArray[n6 + n11] = 0;
            }
            int n12 = 0;
            while (n11 < n9) {
                byArray[n6 + n11] = unsafe.getByte(l2 + (long)(n12 += nArray[n11]));
                ++n11;
            }
            while (n11 < n5) {
                byArray[n6 + n11] = 0;
                ++n11;
            }
        }
        IntArrayCache.fill(nArray, n7, n8 + 1, 0);
    }

    @Override
    public void setAndClearRelativeAlphas(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        byte[] byArray = this.alphas;
        int n5 = this.width;
        int n6 = (n2 - this.y) * n5;
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l2 = this.ALPHA_MAP_USED.address;
        int n7 = n3 - this.x;
        int n8 = n4 - this.x;
        int n9 = Math.min(n8, this.width);
        boolean bl2 = this.useFastFill && n9 - n7 < this.fastFillThreshold;
        int n10 = MarlinConst.BLOCK_SIZE_LG;
        int n11 = n7 >> n10;
        int n12 = (n9 >> n10) + 1;
        nArray[n12] = 0;
        int n13 = 0;
        int n14 = Integer.MAX_VALUE;
        if (bl2) {
            byte by2;
            int n15 = n7;
            Arrays.fill(byArray, n6, n6 + n5, (byte)0);
            for (int i2 = n11; i2 <= n12; ++i2) {
                if (nArray[i2] != 0) {
                    nArray[i2] = 0;
                    if (n14 != Integer.MAX_VALUE) continue;
                    n14 = i2;
                    continue;
                }
                if (n14 == Integer.MAX_VALUE) continue;
                int n16 = FloatMath.max(n14 << n10, n7);
                n14 = Integer.MAX_VALUE;
                int n17 = FloatMath.min((i2 << n10) + 1, n9);
                for (int i3 = n16; i3 < n17; ++i3) {
                    int n18 = nArray2[i3];
                    if (n18 == 0) continue;
                    nArray2[i3] = 0;
                    if (i3 != n15) {
                        if (n13 == 0) {
                            n15 = i3;
                        } else {
                            by2 = unsafe.getByte(l2 + (long)n13);
                            do {
                                byArray[n6 + n15] = by2;
                            } while (++n15 < i3);
                        }
                    }
                    n13 += n18;
                }
            }
            if (n13 != 0) {
                by2 = unsafe.getByte(l2 + (long)n13);
                while (n15 < n9) {
                    byArray[n6 + n15] = by2;
                    ++n15;
                }
            }
        } else {
            byte by3;
            int n19;
            for (n19 = 0; n19 < n7; ++n19) {
                byArray[n6 + n19] = 0;
            }
            for (int i4 = n11; i4 <= n12; ++i4) {
                if (nArray[i4] != 0) {
                    nArray[i4] = 0;
                    if (n14 != Integer.MAX_VALUE) continue;
                    n14 = i4;
                    continue;
                }
                if (n14 == Integer.MAX_VALUE) continue;
                int n20 = FloatMath.max(n14 << n10, n7);
                n14 = Integer.MAX_VALUE;
                int n21 = FloatMath.min((i4 << n10) + 1, n9);
                for (int i5 = n20; i5 < n21; ++i5) {
                    int n22 = nArray2[i5];
                    if (n22 == 0) continue;
                    nArray2[i5] = 0;
                    if (i5 != n19) {
                        by3 = unsafe.getByte(l2 + (long)n13);
                        do {
                            byArray[n6 + n19] = by3;
                        } while (++n19 < i5);
                    }
                    n13 += n22;
                }
            }
            if (n13 != 0) {
                by3 = unsafe.getByte(l2 + (long)n13);
                while (n19 < n9) {
                    byArray[n6 + n19] = by3;
                    ++n19;
                }
            }
            while (n19 < n5) {
                byArray[n6 + n19] = 0;
                ++n19;
            }
        }
        nArray2[n9] = 0;
        if (MarlinConst.DO_CHECKS) {
            IntArrayCache.check(nArray, n11, n12, 0);
            IntArrayCache.check(nArray2, n7, n8 + 1, 0);
        }
    }

    static {
        Unsafe unsafe = OffHeapArray.UNSAFE;
        byte[] byArray = MaskMarlinAlphaConsumer.buildAlphaMap(MarlinConst.MAX_AA_ALPHA);
        ALPHA_MAP = byArray;
        ALPHA_MAP_UNSAFE = new OffHeapArray(ALPHA_MAP, ALPHA_MAP.length);
        long l2 = MaskMarlinAlphaConsumer.ALPHA_MAP_UNSAFE.address;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            unsafe.putByte(l2 + (long)i2, byArray[i2]);
        }
        byte[] byArray2 = MaskMarlinAlphaConsumer.buildAlphaMap(1);
        ALPHA_MAP_NO_AA = byArray2;
        ALPHA_MAP_UNSAFE_NO_AA = new OffHeapArray(ALPHA_MAP_NO_AA, ALPHA_MAP_NO_AA.length);
        l2 = MaskMarlinAlphaConsumer.ALPHA_MAP_UNSAFE_NO_AA.address;
        for (int i3 = 0; i3 < byArray2.length; ++i3) {
            unsafe.putByte(l2 + (long)i3, byArray2[i3]);
        }
    }
}

