/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class ToggleButtonBehavior<C extends ToggleButton>
extends ButtonBehavior<C> {
    public ToggleButtonBehavior(C c2) {
        super(c2);
        ObservableList<InputMap.Mapping> observableList = FXCollections.observableArrayList(new InputMap.KeyMapping(KeyCode.RIGHT, keyEvent -> this.traverse((KeyEvent)keyEvent, "ToggleNext-Right")), new InputMap.KeyMapping(KeyCode.LEFT, keyEvent -> this.traverse((KeyEvent)keyEvent, "TogglePrevious-Left")), new InputMap.KeyMapping(KeyCode.DOWN, keyEvent -> this.traverse((KeyEvent)keyEvent, "ToggleNext-Down")), new InputMap.KeyMapping(KeyCode.UP, keyEvent -> this.traverse((KeyEvent)keyEvent, "TogglePrevious-Up")));
        for (InputMap.Mapping mapping : observableList) {
            mapping.setAutoConsume(false);
        }
        InputMap<C> inputMap = new InputMap<C>(c2);
        inputMap.getMappings().addAll((Collection<InputMap.Mapping<?>>)observableList);
        this.addDefaultChildMap(this.getInputMap(), inputMap);
    }

    private int nextToggleIndex(ObservableList<Toggle> observableList, int n2) {
        Toggle toggle;
        if (n2 < 0 || n2 >= observableList.size()) {
            return 0;
        }
        int n3 = (n2 + 1) % observableList.size();
        while (n3 != n2 && (toggle = (Toggle)observableList.get(n3)) instanceof Node && ((Node)((Object)toggle)).isDisabled()) {
            n3 = (n3 + 1) % observableList.size();
        }
        return n3;
    }

    private int previousToggleIndex(ObservableList<Toggle> observableList, int n2) {
        Toggle toggle;
        if (n2 < 0 || n2 >= observableList.size()) {
            return observableList.size();
        }
        int n3 = Math.floorMod(n2 - 1, observableList.size());
        while (n3 != n2 && (toggle = (Toggle)observableList.get(n3)) instanceof Node && ((Node)((Object)toggle)).isDisabled()) {
            n3 = Math.floorMod(n3 - 1, observableList.size());
        }
        return n3;
    }

    private void traverse(KeyEvent keyEvent, String string) {
        ToggleButton toggleButton = (ToggleButton)this.getNode();
        ToggleGroup toggleGroup = toggleButton.getToggleGroup();
        if (toggleGroup == null) {
            keyEvent.consume();
            return;
        }
        ObservableList<Toggle> observableList = toggleGroup.getToggles();
        int n2 = observableList.indexOf(toggleButton);
        boolean bl2 = this.traversingToNext(string, toggleButton.getEffectiveNodeOrientation());
        if (!Utils.isTwoLevelFocus()) {
            if (bl2) {
                int n3 = this.nextToggleIndex(observableList, n2);
                if (n3 != n2) {
                    Toggle toggle = (Toggle)observableList.get(n3);
                    toggleGroup.selectToggle(toggle);
                    ((Control)((Object)toggle)).requestFocus();
                    keyEvent.consume();
                }
            } else {
                int n4 = this.previousToggleIndex(observableList, n2);
                if (n4 != n2) {
                    Toggle toggle = (Toggle)observableList.get(n4);
                    toggleGroup.selectToggle(toggle);
                    ((Control)((Object)toggle)).requestFocus();
                    keyEvent.consume();
                }
            }
        }
    }

    private boolean traversingToNext(String string, NodeOrientation nodeOrientation) {
        boolean bl2 = nodeOrientation == NodeOrientation.RIGHT_TO_LEFT;
        switch (string) {
            case "ToggleNext-Right": {
                return !bl2;
            }
            case "ToggleNext-Down": {
                return true;
            }
            case "TogglePrevious-Left": {
                return bl2;
            }
            case "TogglePrevious-Up": {
                return false;
            }
        }
        throw new IllegalArgumentException("Not a toggle action");
    }
}

