/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

final class GtkView
extends View {
    private boolean imEnabled = false;
    private boolean isInPreeditMode = false;
    private final StringBuilder preedit = new StringBuilder();
    private ByteBuffer attributes;
    private int lastCaret;

    GtkView() {
    }

    private native void enableInputMethodEventsImpl(long var1, boolean var3);

    @Override
    protected void _enableInputMethodEvents(long l2, boolean bl2) {
        this.enableInputMethodEventsImpl(l2, bl2);
        if (this.imEnabled) {
            this.preedit.setLength(0);
        }
        this.imEnabled = bl2;
    }

    @Override
    protected int _getNativeFrameBuffer(long l2) {
        return 0;
    }

    @Override
    protected native long _create(Map var1);

    @Override
    protected native long _getNativeView(long var1);

    @Override
    protected native int _getX(long var1);

    @Override
    protected native int _getY(long var1);

    @Override
    protected native void _setParent(long var1, long var3);

    @Override
    protected native boolean _close(long var1);

    @Override
    protected native void _scheduleRepaint(long var1);

    @Override
    protected void _begin(long l2) {
    }

    @Override
    protected void _end(long l2) {
    }

    @Override
    protected void _uploadPixels(long l2, Pixels pixels) {
        Buffer buffer = pixels.getPixels();
        if (buffer.isDirect()) {
            this._uploadPixelsDirect(l2, buffer, pixels.getWidth(), pixels.getHeight());
        } else if (buffer.hasArray()) {
            if (pixels.getBytesPerComponent() == 1) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                this._uploadPixelsByteArray(l2, byteBuffer.array(), byteBuffer.arrayOffset(), pixels.getWidth(), pixels.getHeight());
            } else {
                IntBuffer intBuffer = (IntBuffer)buffer;
                this._uploadPixelsIntArray(l2, intBuffer.array(), intBuffer.arrayOffset(), pixels.getWidth(), pixels.getHeight());
            }
        } else {
            this._uploadPixelsDirect(l2, pixels.asByteBuffer(), pixels.getWidth(), pixels.getHeight());
        }
    }

    private native void _uploadPixelsDirect(long var1, Buffer var3, int var4, int var5);

    private native void _uploadPixelsByteArray(long var1, byte[] var3, int var4, int var5, int var6);

    private native void _uploadPixelsIntArray(long var1, int[] var3, int var4, int var5, int var6);

    @Override
    protected native boolean _enterFullscreen(long var1, boolean var3, boolean var4, boolean var5);

    @Override
    protected native void _exitFullscreen(long var1, boolean var3);

    @Override
    protected void _finishInputMethodComposition(long l2) {
        if (this.imEnabled && this.isInPreeditMode) {
            this.preedit.setLength(0);
            this.notifyInputMethod(this.preedit.toString(), null, null, null, 0, 0, 0);
        }
    }

    private void notifyPreeditMode(boolean bl2) {
        this.isInPreeditMode = bl2;
    }

    protected void notifyInputMethodDraw(String string, int n2, int n3, int n4, byte[] byArray) {
        Object object;
        int[] nArray = null;
        byte[] byArray2 = null;
        if (this.attributes == null) {
            this.attributes = ByteBuffer.allocate(32);
        }
        if (n3 > 0) {
            this.preedit.replace(n2, n2 + n3, "");
        }
        if (string != null) {
            this.preedit.insert(n2, string);
        } else if (byArray == null) {
            this.preedit.setLength(0);
        }
        if (this.attributes.capacity() < this.preedit.length()) {
            object = ByteBuffer.allocate((int)((double)this.preedit.length() * 1.5));
            ((ByteBuffer)object).put(this.attributes);
            this.attributes = object;
        }
        this.attributes.limit(this.preedit.length());
        if (byArray != null && this.attributes.limit() >= n2 + byArray.length) {
            this.attributes.position(n2);
            this.attributes.put(byArray);
        }
        if (this.attributes.limit() > 0) {
            object = new ArrayList();
            ArrayList<Byte> arrayList = new ArrayList<Byte>();
            this.attributes.rewind();
            byte by2 = this.attributes.get();
            ((ArrayList)object).add(0);
            arrayList.add(by2);
            int n5 = 1;
            while (this.attributes.hasRemaining()) {
                byte by3 = this.attributes.get();
                if (by2 != by3) {
                    ((ArrayList)object).add(n5);
                    arrayList.add(by3);
                }
                by2 = by3;
                ++n5;
            }
            ((ArrayList)object).add(this.attributes.limit());
            nArray = new int[((ArrayList)object).size()];
            n5 = 0;
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                Integer number = (Integer)iterator.next();
                nArray[n5++] = number;
            }
            byArray2 = new byte[arrayList.size()];
            n5 = 0;
            for (Byte by3 : arrayList) {
                byArray2[n5++] = by3;
            }
        }
        this.notifyInputMethod(this.preedit.toString(), nArray, nArray, byArray2, 0, n4, 0);
        this.lastCaret = n4;
    }

    protected void notifyInputMethodCaret(int n2, int n3, int n4) {
        switch (n3) {
            case 0: {
                this.lastCaret += n2;
                break;
            }
            case 1: {
                this.lastCaret -= n2;
                break;
            }
            case 10: {
                this.lastCaret = n2;
                break;
            }
        }
        this.notifyInputMethod(this.preedit.toString(), null, null, null, 0, this.lastCaret, 0);
    }
}

