/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.gtk.GtkCommonDialogs;
import com.sun.glass.ui.gtk.GtkCursor;
import com.sun.glass.ui.gtk.GtkPixels;
import com.sun.glass.ui.gtk.GtkRobot;
import com.sun.glass.ui.gtk.GtkTimer;
import com.sun.glass.ui.gtk.GtkView;
import com.sun.glass.ui.gtk.GtkWindow;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import com.sun.prism.impl.PrismSettings;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

final class GtkApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    private static final String SWT_INTERNAL_CLASS = "org.eclipse.swt.internal.gtk.OS";
    private static final int forcedGtkVersion;
    private static boolean gtk2WarningIssued;
    private static final String GTK2_ALREADY_LOADED_WARNING = "WARNING: Found GTK 2 library already loaded";
    private static final String GTK2_SPECIFIED_WARNING = "WARNING: A command line option has enabled the GTK 2 library";
    private static final String GTK2_FALLBACK_WARNING = "WARNING: Using GTK 2 library because GTK 3 cannot be loaded ";
    private static final String GTK2_DEPRECATION_WARNING = "WARNING: The JavaFX GTK 2 library is deprecated and will be removed in a future release";
    public static int screen;
    public static long display;
    public static long visualID;
    static float overrideUIScale;
    private final InvokeLaterDispatcher invokeLaterDispatcher;
    private static final int QUERY_ERROR = -2;
    private static final int QUERY_NO_DISPLAY = -1;
    private static final int QUERY_USE_CURRENT = 1;
    private static final int QUERY_LOAD_GTK2 = 2;
    private static final int QUERY_LOAD_GTK3 = 3;
    private Object eventLoopExitEnterPassValue;

    private static float getFloat(String string, float f2, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            string3 = System.getenv(string);
        }
        if (string3 == null) {
            return f2;
        }
        float f3 = (string3 = string3.trim()).endsWith("%") ? (float)Integer.parseInt(string3.substring(0, string3.length() - 1)) / 100.0f : (string3.endsWith("DPI") || string3.endsWith("dpi") ? (float)Integer.parseInt(string3.substring(0, string3.length() - 3)) / 96.0f : Float.parseFloat(string3));
        if (PrismSettings.verbose) {
            System.out.println(string2 + f3);
        }
        return f3;
    }

    GtkApplication() {
        float f2;
        int n2;
        int n3 = n2 = forcedGtkVersion == 0 ? AccessController.doPrivileged(() -> {
            String string = System.getProperty("jdk.gtk.version", "3");
            int n2 = 0;
            if ("3".equals(string) || string.startsWith("3.")) {
                n2 = 3;
            } else if ("2".equals(string) || string.startsWith("2.")) {
                n2 = 2;
            }
            return n2;
        }) : forcedGtkVersion;
        if (n2 == 2 && !gtk2WarningIssued) {
            System.err.println(GTK2_SPECIFIED_WARNING);
            System.err.println(GTK2_DEPRECATION_WARNING);
            gtk2WarningIssued = true;
        }
        boolean bl2 = AccessController.doPrivileged(() -> Boolean.getBoolean("jdk.gtk.verbose"));
        overrideUIScale = PrismSettings.allowHiDPIScaling ? (f2 = AccessController.doPrivileged(() -> Float.valueOf(GtkApplication.getFloat("glass.gtk.uiScale", -1.0f, "Forcing UI scaling factor: "))).floatValue()) : -1.0f;
        int n4 = GtkApplication._queryLibrary(n2, bl2);
        Void void_ = AccessController.doPrivileged(() -> {
            if (n4 == -1) {
                throw new UnsupportedOperationException("Unable to open DISPLAY");
            }
            if (n4 == 1) {
                if (bl2) {
                    System.out.println("Glass GTK library to load is already loaded");
                }
            } else if (n4 == 2) {
                if (bl2) {
                    System.out.println("Glass GTK library to load is glassgtk2");
                }
                NativeLibLoader.loadLibrary("glassgtk2");
                if (!gtk2WarningIssued) {
                    System.err.println(GTK2_FALLBACK_WARNING);
                    System.err.println(GTK2_DEPRECATION_WARNING);
                    gtk2WarningIssued = true;
                }
            } else if (n4 == 3) {
                if (bl2) {
                    System.out.println("Glass GTK library to load is glassgtk3");
                }
                NativeLibLoader.loadLibrary("glassgtk3");
            } else {
                throw new UnsupportedOperationException("Internal Error");
            }
            return null;
        });
        int n5 = GtkApplication._initGTK(n2, bl2, overrideUIScale);
        if (n5 == -1) {
            throw new RuntimeException("Error loading GTK libraries");
        }
        boolean bl3 = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (!bl3) {
            this.invokeLaterDispatcher = new InvokeLaterDispatcher(this);
            this.invokeLaterDispatcher.start();
        } else {
            this.invokeLaterDispatcher = null;
        }
    }

    private static native int _queryLibrary(int var0, boolean var1);

    private static native int _initGTK(int var0, boolean var1, float var2);

    private void initDisplay() {
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Object v2 = map.get("XDisplay");
            if (v2 != null) {
                display = (Long)v2;
            }
            if ((v2 = map.get("XVisualID")) != null) {
                visualID = (Long)v2;
            }
            if ((v2 = map.get("XScreenID")) != null) {
                screen = (Integer)v2;
            }
        }
    }

    private void init() {
        this.initDisplay();
        long l2 = 0L;
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Long l3 = (Long)map.get("javafx.embed.eventProc");
            l2 = l3 == null ? 0L : l3;
        }
        boolean bl2 = AccessController.doPrivileged(() -> Boolean.getBoolean("sun.awt.disablegrab") || Boolean.getBoolean("glass.disableGrab"));
        this._init(l2, bl2);
    }

    @Override
    protected void runLoop(Runnable runnable) {
        boolean bl2 = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.embed.isEventThread"));
        if (bl2) {
            this.init();
            GtkApplication.setEventThread(Thread.currentThread());
            runnable.run();
            return;
        }
        boolean bl3 = AccessController.doPrivileged(() -> Boolean.getBoolean("glass.noErrorTrap"));
        Thread thread = AccessController.doPrivileged(() -> new Thread(() -> {
            this.init();
            this._runLoop(runnable, bl3);
        }, "GtkNativeMainLoopThread"));
        GtkApplication.setEventThread(thread);
        thread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread thread = GtkApplication.getEventThread();
        if (thread != null) {
            this._terminateLoop();
            GtkApplication.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private native void _terminateLoop();

    private native void _init(long var1, boolean var3);

    private native void _runLoop(Runnable var1, boolean var2);

    @Override
    protected void _invokeAndWait(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeAndWait(runnable);
        } else {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.submitForLaterInvocation(() -> {
                if (runnable != null) {
                    runnable.run();
                }
                countDownLatch.countDown();
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable runnable) {
        this._submitForLaterInvocation(runnable);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeLater(runnable);
        } else {
            this.submitForLaterInvocation(runnable);
        }
    }

    private native void enterNestedEventLoopImpl();

    private native void leaveNestedEventLoopImpl();

    @Override
    protected Object _enterNestedEventLoop() {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        try {
            this.enterNestedEventLoopImpl();
            Object object = this.eventLoopExitEnterPassValue;
            this.eventLoopExitEnterPassValue = null;
            Object object2 = object;
            return object2;
        }
        finally {
            if (this.invokeLaterDispatcher != null) {
                this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
            }
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object object) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        }
        this.eventLoopExitEnterPassValue = object;
        this.leaveNestedEventLoopImpl();
    }

    @Override
    public Window createWindow(Window window, Screen screen, int n2) {
        return new GtkWindow(window, screen, n2);
    }

    @Override
    public View createView() {
        return new GtkView();
    }

    @Override
    public Cursor createCursor(int n2) {
        return new GtkCursor(n2);
    }

    @Override
    public Cursor createCursor(int n2, int n3, Pixels pixels) {
        return new GtkCursor(n2, n3, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean bl2) {
    }

    @Override
    protected Size staticCursor_getBestSize(int n2, int n3) {
        return GtkCursor._getBestSize(n2, n3);
    }

    @Override
    public Pixels createPixels(int n2, int n3, ByteBuffer byteBuffer) {
        return new GtkPixels(n2, n3, byteBuffer);
    }

    @Override
    public Pixels createPixels(int n2, int n3, IntBuffer intBuffer) {
        return new GtkPixels(n2, n3, intBuffer);
    }

    @Override
    public Pixels createPixels(int n2, int n3, IntBuffer intBuffer, float f2, float f3) {
        return new GtkPixels(n2, n3, intBuffer, f2, f3);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return 1;
    }

    @Override
    public GlassRobot createRobot() {
        return new GtkRobot();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new GtkTimer(runnable);
    }

    @Override
    protected native int staticTimer_getMinPeriod();

    @Override
    protected native int staticTimer_getMaxPeriod();

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n2, boolean bl2, CommonDialogs.ExtensionFilter[] extensionFilterArray, int n3) {
        return GtkCommonDialogs.showFileChooser(window, string, string2, string3, n2, bl2, extensionFilterArray, n3);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        return GtkCommonDialogs.showFolderChooser(window, string, string2);
    }

    @Override
    protected native long staticView_getMultiClickTime();

    @Override
    protected native int staticView_getMultiClickMaxX();

    @Override
    protected native int staticView_getMultiClickMaxY();

    @Override
    protected boolean _supportsInputMethods() {
        return true;
    }

    @Override
    protected native boolean _supportsTransparentWindows();

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    @Override
    protected native int _getKeyCodeForChar(char var1);

    @Override
    protected native int _isKeyLocked(int var1);

    static {
        Object object;
        gtk2WarningIssued = false;
        Class clazz = AccessController.doPrivileged(() -> {
            try {
                return Class.forName(SWT_INTERNAL_CLASS, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception exception) {
                try {
                    return Class.forName(SWT_INTERNAL_CLASS, true, Thread.currentThread().getContextClassLoader());
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        });
        if (clazz != null) {
            object = Logging.getJavaFXLogger();
            ((PlatformLogger)object).fine("SWT-GTK library found. Try to obtain GTK version.");
            Method method = AccessController.doPrivileged(() -> {
                try {
                    return clazz.getMethod("gtk_major_version", new Class[0]);
                }
                catch (Exception exception) {
                    return null;
                }
            });
            int n2 = 0;
            if (method != null) {
                try {
                    n2 = ((Number)method.invoke((Object)clazz, new Object[0])).intValue();
                }
                catch (Exception exception) {
                    ((PlatformLogger)object).warning("Method gtk_major_version() of the org.eclipse.swt.internal.gtk.OS class returns error. SWT GTK version cannot be detected. GTK3 will be used as default.");
                    n2 = 3;
                }
            }
            if (n2 < 2 || n2 > 3) {
                ((PlatformLogger)object).warning("SWT-GTK uses unsupported major GTK version " + n2 + ". GTK3 will be used as default.");
                n2 = 3;
            }
            forcedGtkVersion = n2;
            if (n2 == 2 && !gtk2WarningIssued) {
                System.err.println(GTK2_ALREADY_LOADED_WARNING);
                System.err.println(GTK2_DEPRECATION_WARNING);
                gtk2WarningIssued = true;
            }
        } else {
            forcedGtkVersion = 0;
        }
        object = AccessController.doPrivileged(() -> {
            Application.loadNativeLibrary();
            return null;
        });
        screen = -1;
        display = 0L;
        visualID = 0L;
    }
}

