/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.load;

import com.github.fge.msgsimple.InternalBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundleLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.IdentityHashMap;
import java.util.Map;

public final class MessageBundles {
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    private static final Map<Class<? extends MessageBundleLoader>, MessageBundle> BUNDLES = new IdentityHashMap<Class<? extends MessageBundleLoader>, MessageBundle>();

    private MessageBundles() {
    }

    public static synchronized MessageBundle getBundle(Class<? extends MessageBundleLoader> c2) {
        MessageBundle ret = BUNDLES.get(c2);
        if (ret == null) {
            ret = MessageBundles.doGetBundle(c2);
            BUNDLES.put(c2, ret);
        }
        return ret;
    }

    private static MessageBundle doGetBundle(Class<? extends MessageBundleLoader> c2) {
        MessageBundleLoader provider;
        Constructor<? extends MessageBundleLoader> constructor;
        String message = BUNDLE.getMessage("factory.noConstructor");
        try {
            constructor = c2.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException(message, e2);
        }
        message = BUNDLE.getMessage("factory.cannotInstantiate");
        try {
            provider = constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e3) {
            throw new RuntimeException(message, e3);
        }
        catch (IllegalAccessException e4) {
            throw new RuntimeException(message, e4);
        }
        catch (InvocationTargetException e5) {
            throw new RuntimeException(message, e5);
        }
        return BUNDLE.checkNotNull(provider.getBundle(), "factory.illegalProvider");
    }
}

