/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonpatch.diff.DiffOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class DiffProcessor {
    private static final JsonNumEquals EQUIVALENCE = JsonNumEquals.getInstance();
    private final Map<JsonPointer, JsonNode> unchanged;
    private final List<DiffOperation> diffs = new ArrayList<DiffOperation>();

    DiffProcessor(Map<JsonPointer, JsonNode> unchanged) {
        this.unchanged = Collections.unmodifiableMap(new HashMap<JsonPointer, JsonNode>(unchanged));
    }

    void valueReplaced(JsonPointer pointer, JsonNode oldValue, JsonNode newValue) {
        this.diffs.add(DiffOperation.replace(pointer, oldValue, newValue));
    }

    void valueRemoved(JsonPointer pointer, JsonNode value) {
        this.diffs.add(DiffOperation.remove(pointer, value));
    }

    void valueAdded(JsonPointer pointer, JsonNode value) {
        int removalIndex = this.findPreviouslyRemoved(value);
        if (removalIndex != -1) {
            DiffOperation removed = this.diffs.get(removalIndex);
            this.diffs.remove(removalIndex);
            this.diffs.add(DiffOperation.move(removed.getFrom(), value, pointer, value));
            return;
        }
        JsonPointer ptr = this.findUnchangedValue(value);
        DiffOperation op2 = ptr != null ? DiffOperation.copy(ptr, pointer, value) : DiffOperation.add(pointer, value);
        this.diffs.add(op2);
    }

    JsonPatch getPatch() {
        ArrayList<JsonPatchOperation> list = new ArrayList<JsonPatchOperation>();
        for (DiffOperation op2 : this.diffs) {
            list.add(op2.asJsonPatchOperation());
        }
        return new JsonPatch(list);
    }

    @Nullable
    private JsonPointer findUnchangedValue(JsonNode value) {
        for (Map.Entry<JsonPointer, JsonNode> entry : this.unchanged.entrySet()) {
            if (!EQUIVALENCE.equivalent(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private int findPreviouslyRemoved(JsonNode value) {
        for (int i2 = 0; i2 < this.diffs.size(); ++i2) {
            DiffOperation op2 = this.diffs.get(i2);
            if (op2.getType() != DiffOperation.Type.REMOVE || !EQUIVALENCE.equivalent(value, op2.getOldValue())) continue;
            return i2;
        }
        return -1;
    }
}

