/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.node.InternalNodeMapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

class NodeSerialization
implements Serializable,
Externalizable {
    protected static final int LONGEST_EAGER_ALLOC = 100000;
    private static final long serialVersionUID = 1L;
    public byte[] json;

    public NodeSerialization() {
    }

    public NodeSerialization(byte[] b2) {
        this.json = b2;
    }

    protected Object readResolve() {
        try {
            return InternalNodeMapper.bytesToNode(this.json);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Failed to JDK deserialize `JsonNode` value: " + e2.getMessage(), e2);
        }
    }

    public static NodeSerialization from(Object o2) {
        try {
            return new NodeSerialization(InternalNodeMapper.valueToBytes(o2));
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Failed to JDK serialize `" + o2.getClass().getSimpleName() + "` value: " + e2.getMessage(), e2);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.json.length);
        out.write(this.json);
    }

    @Override
    public void readExternal(ObjectInput in2) throws IOException {
        int len = in2.readInt();
        this.json = this._read(in2, len);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] _read(ObjectInput in2, int expLen) throws IOException {
        if (expLen <= 100000) {
            byte[] result = new byte[expLen];
            in2.readFully(result, 0, expLen);
            return result;
        }
        try (ByteArrayBuilder bb2 = new ByteArrayBuilder(100000);){
            byte[] buffer = bb2.resetAndGetFirstSegment();
            int outOffset = 0;
            while (true) {
                int toRead = Math.min(buffer.length - outOffset, expLen);
                in2.readFully(buffer, 0, toRead);
                outOffset += toRead;
                if ((expLen -= toRead) == 0) {
                    byte[] byArray = bb2.completeAndCoalesce(outOffset);
                    return byArray;
                }
                if (outOffset != buffer.length) continue;
                buffer = bb2.finishCurrentSegment();
                outOffset = 0;
                continue;
                break;
            }
        }
    }
}

