/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.FftMultiplier;
import java.math.BigInteger;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

class FastIntegerMath {
    public static final BigInteger FIVE = BigInteger.valueOf(5L);
    static final BigInteger TEN_POW_16 = BigInteger.valueOf(10000000000000000L);
    static final BigInteger FIVE_POW_16 = BigInteger.valueOf(152587890625L);
    private static final BigInteger[] SMALL_POWERS_OF_TEN = new BigInteger[]{BigInteger.ONE, BigInteger.TEN, BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L), BigInteger.valueOf(10000000000L), BigInteger.valueOf(100000000000L), BigInteger.valueOf(1000000000000L), BigInteger.valueOf(10000000000000L), BigInteger.valueOf(100000000000000L), BigInteger.valueOf(1000000000000000L)};

    private FastIntegerMath() {
    }

    static BigInteger computePowerOfTen(NavigableMap<Integer, BigInteger> powersOfTen, int n2) {
        if (n2 < SMALL_POWERS_OF_TEN.length) {
            return SMALL_POWERS_OF_TEN[n2];
        }
        if (powersOfTen != null) {
            Map.Entry<Integer, BigInteger> floorEntry = powersOfTen.floorEntry(n2);
            Integer floorN = floorEntry.getKey();
            if (floorN == n2) {
                return floorEntry.getValue();
            }
            return FftMultiplier.multiply(floorEntry.getValue(), FastIntegerMath.computePowerOfTen(powersOfTen, n2 - floorN));
        }
        return FIVE.pow(n2).shiftLeft(n2);
    }

    static BigInteger computeTenRaisedByNFloor16Recursive(NavigableMap<Integer, BigInteger> powersOfTen, int n2) {
        Map.Entry<Integer, BigInteger> floorEntry = powersOfTen.floorEntry(n2 &= 0xFFFFFFF0);
        int floorPower = floorEntry.getKey();
        BigInteger floorValue = floorEntry.getValue();
        if (floorPower == n2) {
            return floorValue;
        }
        int diff = n2 - floorPower;
        BigInteger diffValue = (BigInteger)powersOfTen.get(diff);
        if (diffValue == null) {
            diffValue = FastIntegerMath.computeTenRaisedByNFloor16Recursive(powersOfTen, diff);
            powersOfTen.put(diff, diffValue);
        }
        return FftMultiplier.multiply(floorValue, diffValue);
    }

    static NavigableMap<Integer, BigInteger> createPowersOfTenFloor16Map() {
        TreeMap<Integer, BigInteger> powersOfTen = new TreeMap<Integer, BigInteger>();
        powersOfTen.put(0, BigInteger.ONE);
        powersOfTen.put(16, TEN_POW_16);
        return powersOfTen;
    }

    public static long estimateNumBits(long numDecimalDigits) {
        return (numDecimalDigits * 3402L >>> 10) + 1L;
    }

    static NavigableMap<Integer, BigInteger> fillPowersOf10Floor16(int from, int to) {
        TreeMap<Integer, BigInteger> powers = new TreeMap<Integer, BigInteger>();
        powers.put(0, BigInteger.valueOf(5L));
        powers.put(16, FIVE_POW_16);
        FastIntegerMath.fillPowersOfNFloor16Recursive(powers, from, to);
        for (Map.Entry entry : powers.entrySet()) {
            entry.setValue(((BigInteger)entry.getValue()).shiftLeft((Integer)entry.getKey()));
        }
        return powers;
    }

    static void fillPowersOfNFloor16Recursive(NavigableMap<Integer, BigInteger> powersOfTen, int from, int to) {
        int numDigits = to - from;
        if (numDigits <= 18) {
            return;
        }
        int mid = FastIntegerMath.splitFloor16(from, to);
        int n2 = to - mid;
        if (!powersOfTen.containsKey(n2)) {
            FastIntegerMath.fillPowersOfNFloor16Recursive(powersOfTen, from, mid);
            FastIntegerMath.fillPowersOfNFloor16Recursive(powersOfTen, mid, to);
            powersOfTen.put(n2, FastIntegerMath.computeTenRaisedByNFloor16Recursive(powersOfTen, n2));
        }
    }

    static UInt128 fullMultiplication(long x2, long y2) {
        return new UInt128(Math.unsignedMultiplyHigh(x2, y2), x2 * y2);
    }

    static int splitFloor16(int from, int to) {
        int mid = from + to >>> 1;
        mid = to - (to - mid + 15 >> 4 << 4);
        return mid;
    }

    static class UInt128 {
        final long high;
        final long low;

        private UInt128(long high, long low) {
            this.high = high;
            this.low = low;
        }
    }
}

