/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import java.util.Arrays;

abstract class AbstractNumberParser {
    public static final String ILLEGAL_OFFSET_OR_ILLEGAL_LENGTH = "offset < 0 or length > str.length";
    public static final String SYNTAX_ERROR = "illegal syntax";
    public static final String VALUE_EXCEEDS_LIMITS = "value exceeds limits";
    static final byte DECIMAL_POINT_CLASS = -4;
    static final byte OTHER_CLASS = -1;
    static final byte[] CHAR_TO_HEX_MAP;

    AbstractNumberParser() {
    }

    protected static byte charAt(byte[] str, int i2, int endIndex) {
        return i2 < endIndex ? str[i2] : (byte)0;
    }

    protected static char charAt(char[] str, int i2, int endIndex) {
        return i2 < endIndex ? str[i2] : (char)'\u0000';
    }

    protected static char charAt(CharSequence str, int i2, int endIndex) {
        return i2 < endIndex ? str.charAt(i2) : (char)'\u0000';
    }

    protected static int lookupHex(byte ch2) {
        return CHAR_TO_HEX_MAP[ch2 & 0xFF];
    }

    protected static int lookupHex(char ch2) {
        return ch2 < '\u0080' ? CHAR_TO_HEX_MAP[ch2] : -1;
    }

    static {
        int ch2;
        CHAR_TO_HEX_MAP = new byte[256];
        Arrays.fill(CHAR_TO_HEX_MAP, (byte)-1);
        for (ch2 = 48; ch2 <= 57; ch2 = (int)((char)(ch2 + 1))) {
            AbstractNumberParser.CHAR_TO_HEX_MAP[ch2] = (byte)(ch2 - 48);
        }
        for (ch2 = 65; ch2 <= 70; ch2 = (int)((char)(ch2 + 1))) {
            AbstractNumberParser.CHAR_TO_HEX_MAP[ch2] = (byte)(ch2 - 65 + 10);
        }
        for (ch2 = 97; ch2 <= 102; ch2 = (int)((char)(ch2 + 1))) {
            AbstractNumberParser.CHAR_TO_HEX_MAP[ch2] = (byte)(ch2 - 97 + 10);
        }
        for (ch2 = 46; ch2 <= 46; ch2 = (int)((char)(ch2 + 1))) {
            AbstractNumberParser.CHAR_TO_HEX_MAP[ch2] = -4;
        }
    }
}

