/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.UTF8Writer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.util.Arrays;

public final class JsonStringEncoder {
    private static final char[] HC = CharTypes.copyHexChars(true);
    private static final byte[] HB = CharTypes.copyHexBytes(true);
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    static final int MIN_CHAR_BUFFER_SIZE = 16;
    static final int MAX_CHAR_BUFFER_SIZE = 32000;
    static final int MIN_BYTE_BUFFER_SIZE = 24;
    static final int MAX_BYTE_BUFFER_SIZE = 32000;
    private static final JsonStringEncoder instance = new JsonStringEncoder();

    public static JsonStringEncoder getInstance() {
        return instance;
    }

    public char[] quoteAsString(String input) {
        int inputLen = input.length();
        char[] outputBuffer = new char[JsonStringEncoder._initialCharBufSize(inputLen)];
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escCodeCount = escCodes.length;
        int inPtr = 0;
        TextBuffer textBuffer = null;
        int outPtr = 0;
        char[] qbuf = null;
        block6: while (inPtr < inputLen) {
            char d2;
            int escCode;
            int length;
            char c2;
            while ((c2 = input.charAt(inPtr)) >= escCodeCount || escCodes[c2] == 0) {
                if (outPtr >= outputBuffer.length) {
                    if (textBuffer == null) {
                        textBuffer = TextBuffer.fromInitial(outputBuffer);
                    }
                    try {
                        outputBuffer = textBuffer.finishCurrentSegment();
                    }
                    catch (IOException e2) {
                        throw new IllegalStateException(e2);
                    }
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = c2;
                if (++inPtr < inputLen) continue;
                break block6;
            }
            if (qbuf == null) {
                qbuf = this._qbuf();
            }
            int n2 = length = (escCode = escCodes[d2 = input.charAt(inPtr++)]) < 0 ? this._appendNumeric(d2, qbuf) : this._appendNamed(escCode, qbuf);
            if (outPtr + length > outputBuffer.length) {
                int first = outputBuffer.length - outPtr;
                if (first > 0) {
                    System.arraycopy(qbuf, 0, outputBuffer, outPtr, first);
                }
                if (textBuffer == null) {
                    textBuffer = TextBuffer.fromInitial(outputBuffer);
                }
                try {
                    outputBuffer = textBuffer.finishCurrentSegment();
                }
                catch (IOException e3) {
                    throw new IllegalStateException(e3);
                }
                int second = length - first;
                System.arraycopy(qbuf, first, outputBuffer, 0, second);
                outPtr = second;
                continue;
            }
            System.arraycopy(qbuf, 0, outputBuffer, outPtr, length);
            outPtr += length;
        }
        if (textBuffer == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outPtr);
        }
        textBuffer.setCurrentLength(outPtr);
        try {
            return textBuffer.contentsAsArray();
        }
        catch (IOException e4) {
            throw new IllegalStateException(e4);
        }
    }

    public char[] quoteAsString(CharSequence input) {
        if (input instanceof String) {
            return this.quoteAsString((String)input);
        }
        TextBuffer textBuffer = null;
        int inputLen = input.length();
        char[] outputBuffer = new char[JsonStringEncoder._initialCharBufSize(inputLen)];
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escCodeCount = escCodes.length;
        int inPtr = 0;
        int outPtr = 0;
        char[] qbuf = null;
        block6: while (inPtr < inputLen) {
            char d2;
            int escCode;
            int length;
            char c2;
            while ((c2 = input.charAt(inPtr)) >= escCodeCount || escCodes[c2] == 0) {
                if (outPtr >= outputBuffer.length) {
                    if (textBuffer == null) {
                        textBuffer = TextBuffer.fromInitial(outputBuffer);
                    }
                    try {
                        outputBuffer = textBuffer.finishCurrentSegment();
                    }
                    catch (IOException e2) {
                        throw new IllegalStateException(e2);
                    }
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = c2;
                if (++inPtr < inputLen) continue;
                break block6;
            }
            if (qbuf == null) {
                qbuf = this._qbuf();
            }
            int n2 = length = (escCode = escCodes[d2 = input.charAt(inPtr++)]) < 0 ? this._appendNumeric(d2, qbuf) : this._appendNamed(escCode, qbuf);
            if (outPtr + length > outputBuffer.length) {
                int first = outputBuffer.length - outPtr;
                if (first > 0) {
                    System.arraycopy(qbuf, 0, outputBuffer, outPtr, first);
                }
                if (textBuffer == null) {
                    textBuffer = TextBuffer.fromInitial(outputBuffer);
                }
                try {
                    outputBuffer = textBuffer.finishCurrentSegment();
                }
                catch (IOException e3) {
                    throw new IllegalStateException(e3);
                }
                int second = length - first;
                System.arraycopy(qbuf, first, outputBuffer, 0, second);
                outPtr = second;
                continue;
            }
            System.arraycopy(qbuf, 0, outputBuffer, outPtr, length);
            outPtr += length;
        }
        if (textBuffer == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outPtr);
        }
        textBuffer.setCurrentLength(outPtr);
        try {
            return textBuffer.contentsAsArray();
        }
        catch (IOException e4) {
            throw new IllegalStateException(e4);
        }
    }

    public void quoteAsString(CharSequence input, StringBuilder output) {
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escCodeCount = escCodes.length;
        int inPtr = 0;
        int inputLen = input.length();
        char[] qbuf = null;
        block0: while (inPtr < inputLen) {
            char d2;
            int escCode;
            char c2;
            while ((c2 = input.charAt(inPtr)) >= escCodeCount || escCodes[c2] == 0) {
                output.append(c2);
                if (++inPtr < inputLen) continue;
                break block0;
            }
            if (qbuf == null) {
                qbuf = this._qbuf();
            }
            int length = (escCode = escCodes[d2 = input.charAt(inPtr++)]) < 0 ? this._appendNumeric(d2, qbuf) : this._appendNamed(escCode, qbuf);
            output.append(qbuf, 0, length);
        }
    }

    public byte[] quoteAsUTF8(String text) {
        int inputPtr = 0;
        int inputEnd = text.length();
        int outputPtr = 0;
        byte[] outputBuffer = new byte[JsonStringEncoder._initialByteBufSize(inputEnd)];
        ByteArrayBuilder bb2 = null;
        block0: while (inputPtr < inputEnd) {
            int ch2;
            int[] escCodes = CharTypes.get7BitOutputEscapes();
            while ((ch2 = text.charAt(inputPtr)) <= 127 && escCodes[ch2] == 0) {
                if (outputPtr >= outputBuffer.length) {
                    if (bb2 == null) {
                        bb2 = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
                    }
                    outputBuffer = bb2.finishCurrentSegment();
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)ch2;
                if (++inputPtr < inputEnd) continue;
                break block0;
            }
            if (bb2 == null) {
                bb2 = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
            }
            if (outputPtr >= outputBuffer.length) {
                outputBuffer = bb2.finishCurrentSegment();
                outputPtr = 0;
            }
            if ((ch2 = text.charAt(inputPtr++)) <= 127) {
                int escape = escCodes[ch2];
                outputPtr = this._appendByte(ch2, escape, bb2, outputPtr);
                outputBuffer = bb2.getCurrentSegment();
                continue;
            }
            if (ch2 <= 2047) {
                outputBuffer[outputPtr++] = (byte)(0xC0 | ch2 >> 6);
                ch2 = 0x80 | ch2 & 0x3F;
            } else if (ch2 < 55296 || ch2 > 57343) {
                outputBuffer[outputPtr++] = (byte)(0xE0 | ch2 >> 12);
                if (outputPtr >= outputBuffer.length) {
                    outputBuffer = bb2.finishCurrentSegment();
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | ch2 >> 6 & 0x3F);
                ch2 = 0x80 | ch2 & 0x3F;
            } else {
                if (ch2 > 56319) {
                    JsonStringEncoder._illegal(ch2);
                }
                if (inputPtr >= inputEnd) {
                    JsonStringEncoder._illegal(ch2);
                }
                if ((ch2 = JsonStringEncoder._convert(ch2, text.charAt(inputPtr++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(ch2);
                }
                outputBuffer[outputPtr++] = (byte)(0xF0 | ch2 >> 18);
                if (outputPtr >= outputBuffer.length) {
                    outputBuffer = bb2.finishCurrentSegment();
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | ch2 >> 12 & 0x3F);
                if (outputPtr >= outputBuffer.length) {
                    outputBuffer = bb2.finishCurrentSegment();
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | ch2 >> 6 & 0x3F);
                ch2 = 0x80 | ch2 & 0x3F;
            }
            if (outputPtr >= outputBuffer.length) {
                outputBuffer = bb2.finishCurrentSegment();
                outputPtr = 0;
            }
            outputBuffer[outputPtr++] = (byte)ch2;
        }
        if (bb2 == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outputPtr);
        }
        return bb2.completeAndCoalesce(outputPtr);
    }

    public byte[] encodeAsUTF8(String text) {
        int inputPtr = 0;
        int inputEnd = text.length();
        int outputPtr = 0;
        byte[] outputBuffer = new byte[JsonStringEncoder._initialByteBufSize(inputEnd)];
        int outputEnd = outputBuffer.length;
        ByteArrayBuilder bb2 = null;
        block0: while (inputPtr < inputEnd) {
            int c2 = text.charAt(inputPtr++);
            while (c2 <= 127) {
                if (outputPtr >= outputEnd) {
                    if (bb2 == null) {
                        bb2 = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
                    }
                    outputBuffer = bb2.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)c2;
                if (inputPtr >= inputEnd) break block0;
                c2 = text.charAt(inputPtr++);
            }
            if (bb2 == null) {
                bb2 = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
            }
            if (outputPtr >= outputEnd) {
                outputBuffer = bb2.finishCurrentSegment();
                outputEnd = outputBuffer.length;
                outputPtr = 0;
            }
            if (c2 < 2048) {
                outputBuffer[outputPtr++] = (byte)(0xC0 | c2 >> 6);
            } else if (c2 < 55296 || c2 > 57343) {
                outputBuffer[outputPtr++] = (byte)(0xE0 | c2 >> 12);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb2.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c2 >> 6 & 0x3F);
            } else {
                if (c2 > 56319) {
                    JsonStringEncoder._illegal(c2);
                }
                if (inputPtr >= inputEnd) {
                    JsonStringEncoder._illegal(c2);
                }
                if ((c2 = JsonStringEncoder._convert(c2, text.charAt(inputPtr++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(c2);
                }
                outputBuffer[outputPtr++] = (byte)(0xF0 | c2 >> 18);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb2.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c2 >> 12 & 0x3F);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb2.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c2 >> 6 & 0x3F);
            }
            if (outputPtr >= outputEnd) {
                outputBuffer = bb2.finishCurrentSegment();
                outputEnd = outputBuffer.length;
                outputPtr = 0;
            }
            outputBuffer[outputPtr++] = (byte)(0x80 | c2 & 0x3F);
        }
        if (bb2 == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outputPtr);
        }
        return bb2.completeAndCoalesce(outputPtr);
    }

    public byte[] encodeAsUTF8(CharSequence text) {
        int inputPtr = 0;
        int inputEnd = text.length();
        int outputPtr = 0;
        byte[] outputBuffer = new byte[JsonStringEncoder._initialByteBufSize(inputEnd)];
        int outputEnd = outputBuffer.length;
        ByteArrayBuilder bb2 = null;
        block0: while (inputPtr < inputEnd) {
            int c2 = text.charAt(inputPtr++);
            while (c2 <= 127) {
                if (outputPtr >= outputEnd) {
                    if (bb2 == null) {
                        bb2 = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
                    }
                    outputBuffer = bb2.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)c2;
                if (inputPtr >= inputEnd) break block0;
                c2 = text.charAt(inputPtr++);
            }
            if (bb2 == null) {
                bb2 = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
            }
            if (outputPtr >= outputEnd) {
                outputBuffer = bb2.finishCurrentSegment();
                outputEnd = outputBuffer.length;
                outputPtr = 0;
            }
            if (c2 < 2048) {
                outputBuffer[outputPtr++] = (byte)(0xC0 | c2 >> 6);
            } else if (c2 < 55296 || c2 > 57343) {
                outputBuffer[outputPtr++] = (byte)(0xE0 | c2 >> 12);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb2.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c2 >> 6 & 0x3F);
            } else {
                if (c2 > 56319) {
                    JsonStringEncoder._illegal(c2);
                }
                if (inputPtr >= inputEnd) {
                    JsonStringEncoder._illegal(c2);
                }
                if ((c2 = JsonStringEncoder._convert(c2, text.charAt(inputPtr++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(c2);
                }
                outputBuffer[outputPtr++] = (byte)(0xF0 | c2 >> 18);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb2.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c2 >> 12 & 0x3F);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb2.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c2 >> 6 & 0x3F);
            }
            if (outputPtr >= outputEnd) {
                outputBuffer = bb2.finishCurrentSegment();
                outputEnd = outputBuffer.length;
                outputPtr = 0;
            }
            outputBuffer[outputPtr++] = (byte)(0x80 | c2 & 0x3F);
        }
        if (bb2 == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outputPtr);
        }
        return bb2.completeAndCoalesce(outputPtr);
    }

    private char[] _qbuf() {
        char[] qbuf = new char[6];
        qbuf[0] = 92;
        qbuf[2] = 48;
        qbuf[3] = 48;
        return qbuf;
    }

    private int _appendNumeric(int value, char[] qbuf) {
        qbuf[1] = 117;
        qbuf[4] = HC[value >> 4];
        qbuf[5] = HC[value & 0xF];
        return 6;
    }

    private int _appendNamed(int esc, char[] qbuf) {
        qbuf[1] = (char)esc;
        return 2;
    }

    private int _appendByte(int ch2, int esc, ByteArrayBuilder bb2, int ptr) {
        bb2.setCurrentSegmentLength(ptr);
        bb2.append(92);
        if (esc < 0) {
            bb2.append(117);
            if (ch2 > 255) {
                int hi2 = ch2 >> 8;
                bb2.append(HB[hi2 >> 4]);
                bb2.append(HB[hi2 & 0xF]);
                ch2 &= 0xFF;
            } else {
                bb2.append(48);
                bb2.append(48);
            }
            bb2.append(HB[ch2 >> 4]);
            bb2.append(HB[ch2 & 0xF]);
        } else {
            bb2.append((byte)esc);
        }
        return bb2.getCurrentSegmentLength();
    }

    private static int _convert(int p1, int p2) {
        if (p2 < 56320 || p2 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(p1) + ", second 0x" + Integer.toHexString(p2) + "; illegal combination");
        }
        return 65536 + (p1 - 55296 << 10) + (p2 - 56320);
    }

    private static void _illegal(int c2) {
        throw new IllegalArgumentException(UTF8Writer.illegalSurrogateDesc(c2));
    }

    static int _initialCharBufSize(int strLen) {
        int estimated = Math.max(16, strLen + Math.min(6 + (strLen >> 3), 1000));
        return Math.min(estimated, 32000);
    }

    static int _initialByteBufSize(int strLen) {
        int doubled = Math.max(24, strLen + 6 + (strLen >> 1));
        return Math.min(doubled, 32000);
    }
}

