/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import liquibase.Scope;
import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.ConfiguredValue;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.pro.LicenseTier;

public class LiquibaseLabsConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<String> LICENSE_KEY;
    public static final ConfigurationDefinition<String> LICENSE_PRO_LICENSE_KEY;

    public static boolean isLabsLicenseValid() {
        Object object = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class);
        if (object == null) {
            return false;
        }
        if ((object = ((LicenseServiceFactory)object).getLicenseService()) == null) {
            return false;
        }
        return object.licenseIsValid("Liquibase Labs");
    }

    public static ConfiguredValue<String> getLicenseKey() {
        if (LICENSE_KEY.getCurrentConfiguredValue().found()) {
            return LICENSE_KEY.getCurrentConfiguredValue();
        }
        if (LICENSE_PRO_LICENSE_KEY.getCurrentConfiguredValue().found()) {
            return LICENSE_PRO_LICENSE_KEY.getCurrentConfiguredValue();
        }
        return null;
    }

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase");
        LICENSE_KEY = builder.define("licenseKey", String.class).setDescription(LicenseTier.PRO.getSubject() + " or " + LicenseTier.LABS.getSubject() + " license key used to unlock paid capabilities. Get a free trial at \nhttps://liquibase.com/trial and use in CLI or add liquibase.licenseKey=<yourKey> into your defaults file.").setValueObfuscator(string -> {
            if (string == null) {
                return null;
            }
            return "license starting with " + string.substring(0, Math.min(string.length(), 10));
        }).build();
        LICENSE_PRO_LICENSE_KEY = builder.define("pro.licenseKey", String.class).setDescription("DEPRECATED: Liquibase Pro license key used to unlock paid capabilities. Get a free trial at\n https://www.liquibase.com/protrial and use in CLI or add liquibase.pro.licenseKey=<yourKey> into your defaults file.").setValueObfuscator(string -> {
            if (string == null) {
                return null;
            }
            return "license starting with " + string.substring(0, Math.min(string.length(), 10));
        }).build();
    }
}

