/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule$SupportedChangesetFormats;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.change.Change;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.SetTableRemarksChange;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class TableCommentPatternCheck
extends AbstractLiquibaseDynamicForecastRule {
    private static final String MESSAGE_TEMPLATE = "A match for regular expression <" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + "> was detected in <IDENTIFIER>.";
    private static final String DATABASE_FAILURE_SUFFIX = " Please review the indicated table for the table comment content.";
    private static final String CHANGESET_FAILURE_SUFFIX = " Please review the indicated changeset for the table comment content.";

    public TableCommentPatternCheck() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getName() {
        return "Table Comment Pattern Check";
    }

    private String getFailureMessage(String string, String string2, ChangeSet changeSet, boolean bl2) {
        return string.replace("<" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + ">", string2).replace("<IDENTIFIER>", changeSet.getId()).concat(bl2 ? CHANGESET_FAILURE_SUFFIX : "");
    }

    private String getFailureMessage(String string, String string2, Table table, boolean bl2) {
        return string.replace("<" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + ">", string2).replace("<IDENTIFIER>", DatabaseObjectUtils.buildFullyQualifiedName(table)).concat(bl2 ? DATABASE_FAILURE_SUFFIX : "");
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        String string = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.SEARCH_STRING);
        String string2 = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.MESSAGE);
        OperatorEnum operatorEnum = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.class);
        boolean bl2 = string2.equalsIgnoreCase(MESSAGE_TEMPLATE);
        for (Change change : changeSet.getChanges()) {
            String string3;
            if (change instanceof CreateTableChange) {
                String string4 = ((CreateTableChange)change).getRemarks();
                if (!this.commentMatchesPattern(operatorEnum, string, string4)) continue;
                this.addFailureRuleIteration(changeSet, this.getFailureMessage(string2, string, changeSet, bl2), dynamicRule);
                continue;
            }
            if (!(change instanceof SetTableRemarksChange) || !this.commentMatchesPattern(operatorEnum, string, string3 = ((SetTableRemarksChange)change).getRemarks())) continue;
            this.addFailureRuleIteration(changeSet, this.getFailureMessage(string2, string, changeSet, bl2), dynamicRule);
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        String string;
        String string2 = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.SEARCH_STRING);
        String string3 = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.MESSAGE);
        OperatorEnum operatorEnum = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.class);
        boolean bl2 = string3.equalsIgnoreCase(MESSAGE_TEMPLATE);
        if (databaseObject instanceof Table && this.commentMatchesPattern(operatorEnum, string2, string = ((Table)databaseObject).getRemarks())) {
            this.addFailureRuleIteration(databaseObject, this.getFailureMessage(string3, string2, (Table)databaseObject, bl2), dynamicRule);
        }
        return this.returnAtEndOfRule(databaseObject, dynamicRule);
    }

    private boolean commentMatchesPattern(OperatorEnum operatorEnum, String string, String string2) {
        return operatorEnum.matches(string, string2, false);
    }

    @Override
    public String getDescription() {
        return "This check triggers when specific user-supplied patterns are found in Table Comments.";
    }

    @Override
    public String getShortName() {
        return "TableCommentPatternCheck";
    }

    @Override
    public int getPriority() {
        return 510;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.OPERATOR, null, null, (Object)OperatorEnum.CONTAINS, false), new RuleParameter(DynamicRuleParameterEnum.SEARCH_STRING, null, null, null, false), new RuleParameter(DynamicRuleParameterEnum.MESSAGE, null, null, MESSAGE_TEMPLATE, false));
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule$SupportedChangesetFormats.MODELED;
    }
}

