/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import liquibase.util.StringUtil;

public class StringListGetter
extends AbstractCommandLineValueGetter<String> {
    private final Set<String> validOptions;

    public StringListGetter() {
        this((Set<String>)null);
    }

    public StringListGetter(Set<String> set) {
        super(String.class);
        this.validOptions = set;
    }

    @Override
    public boolean validate(String string) {
        return StringListGetter.validate(string, this.validOptions, "is not a valid word.");
    }

    @Override
    public String convert(String string) {
        return string.toUpperCase();
    }

    public static boolean validate(String object, Set<String> set, String string) {
        if (set != null) {
            for (String string2 : StringListGetter.split((String)object)) {
                String string3 = string2.toUpperCase();
                if (set.contains(string3)) continue;
                throw new IllegalArgumentException(string2 + " " + string.trim());
            }
        }
        return true;
    }

    public static List<String> split(String string) {
        if (StringUtil.isEmpty(string)) {
            return Collections.emptyList();
        }
        return StringUtil.splitAndTrim(string, ",");
    }
}

