/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicForecastRule;
import java.util.Collections;
import java.util.List;
import liquibase.Labels;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;

public class LabelMustBeSet
extends AbstractLiquibaseBasicForecastRule {
    public LabelMustBeSet() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet) {
        Labels labels = changeSet.getLabels();
        if (labels == null || labels.getLabels().isEmpty()) {
            return this.putResultUnsuccessful(changeSet, "Liquibase recommends that labels be assigned to each changeset to provide better deployment control and to enhance traceability of efforts across changesets.  Review the changeset indicated and consider adding a label to it.");
        }
        return this.putResultSuccessful(changeSet, true, null);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDescription() {
        return "This check enforces the Liquibase recommendation that labels be assigned to each changeset to provide better deployment control and to enhance traceability of efforts across changesets.";
    }

    @Override
    public String getShortName() {
        return "ChangesetLabelCheck";
    }

    @Override
    public int getPriority() {
        return 170;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public String getName() {
        return "Changesets Must Have a Label Assigned";
    }
}

